/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRunListener;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MailReport;
import net.bull.javamelody.MonitoringFilter;
import net.bull.javamelody.NodesCollector;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.RemoteCallHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodesCollector {
    private final boolean monitoringDisabled = Boolean.parseBoolean(Parameters.getParameter((Parameter)Parameter.DISABLED));
    private final Timer timer;
    private final Collector collector;
    private List<JavaInformations> lastJavaInformationsList;

    public NodesCollector(MonitoringFilter filter) {
        if (!this.monitoringDisabled) {
            this.timer = filter.getFilterContext().getTimer();
            List<Counter> counters = Collections.singletonList(CounterRunListener.getBuildCounter());
            this.collector = new RemoteCollector("nodes", counters);
        } else {
            this.timer = null;
            this.collector = null;
        }
    }

    public void init() {
        if (this.monitoringDisabled) {
            return;
        }
        int periodMillis = Parameters.getResolutionSeconds() * 1000;
        1 collectTask = new /* Unavailable Anonymous Inner Class!! */;
        this.timer.schedule((TimerTask)collectTask, 5000L, (long)periodMillis);
        if (Parameters.getParameter((Parameter)Parameter.MAIL_SESSION) != null && Parameters.getParameter((Parameter)Parameter.ADMIN_EMAILS) != null) {
            this.scheduleReportMailForSlaves();
        }
    }

    public void scheduleCollectNow() {
        2 collectTask = new /* Unavailable Anonymous Inner Class!! */;
        this.timer.schedule((TimerTask)collectTask, 0L);
    }

    public void stop() {
        if (this.monitoringDisabled) {
            return;
        }
        this.timer.cancel();
        this.collector.stop();
    }

    public void collectWithoutErrors() {
        try {
            this.lastJavaInformationsList = RemoteCallHelper.collectJavaInformationsList();
            this.collector.collectWithoutErrors(this.lastJavaInformationsList);
        }
        catch (Throwable t) {
            LOG.warn((String)"exception while collecting data", (Throwable)t);
        }
    }

    private void scheduleReportMailForSlaves() {
        for (Period period : MailReport.getMailPeriods()) {
            this.scheduleReportMailForSlaves(period);
        }
    }

    void scheduleReportMailForSlaves(Period period) {
        assert (period != null);
        3 task = new /* Unavailable Anonymous Inner Class!! */;
        this.timer.schedule((TimerTask)task, MailReport.getNextExecutionDate((Period)period));
    }

    Collector getCollector() {
        return this.collector;
    }

    List<JavaInformations> getLastJavaInformationsList() {
        return this.lastJavaInformationsList;
    }

    public boolean isMonitoringDisabled() {
        return this.monitoringDisabled;
    }
}

