/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.remoting.Callable;
import hudson.remoting.Future;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.RemoteCallHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
final class RemoteCallHelper {
    private static final Callable<JavaInformations, Throwable> JAVA_INFORMATIONS_TASK = new /* Unavailable Anonymous Inner Class!! */;
    private static final Callable<HeapHistogram, Throwable> HEAP_HISTOGRAM_TASK = new /* Unavailable Anonymous Inner Class!! */;
    private static final Callable<List<ProcessInformations>, Throwable> PROCESS_INFORMATIONS_TASK = new /* Unavailable Anonymous Inner Class!! */;
    private static final Callable<String, Throwable> MBEANS_HTML_TASK = new /* Unavailable Anonymous Inner Class!! */;

    private RemoteCallHelper() {
    }

    private static <T> Map<String, T> collectDataByNodeName(Callable<T, Throwable> task) throws IOException, InterruptedException, ExecutionException {
        Computer[] computers = Hudson.getInstance().getComputers();
        LinkedHashMap<String, Future> futuresByNodeName = new LinkedHashMap<String, Future>(computers.length);
        DelegatingTask delegatingTask = new DelegatingTask(task);
        for (Computer c : computers) {
            if (!c.isOnline()) continue;
            futuresByNodeName.put(c.getName(), c.getChannel().callAsync((Callable)delegatingTask));
        }
        LinkedHashMap result = new LinkedHashMap(futuresByNodeName.size());
        for (Map.Entry entry : futuresByNodeName.entrySet()) {
            result.put(entry.getKey(), ((Future)entry.getValue()).get());
        }
        return result;
    }

    static List<JavaInformations> collectJavaInformationsList() throws IOException, InterruptedException, ExecutionException {
        Map javaInformationsByNodeName = RemoteCallHelper.collectDataByNodeName((Callable)JAVA_INFORMATIONS_TASK);
        return new ArrayList<JavaInformations>(javaInformationsByNodeName.values());
    }

    static List<String> collectJmxValues(String jmxValueParameter) throws IOException, InterruptedException, ExecutionException {
        return new ArrayList<String>(RemoteCallHelper.collectDataByNodeName((Callable)new JmxValueTask(jmxValueParameter)).values());
    }

    static Map<String, String> collectMBeansHtmlInformations() throws IOException, InterruptedException, ExecutionException {
        return RemoteCallHelper.collectDataByNodeName((Callable)MBEANS_HTML_TASK);
    }

    static Map<String, List<ProcessInformations>> collectProcessInformationsByNodeName() throws IOException, InterruptedException, ExecutionException {
        return RemoteCallHelper.collectDataByNodeName((Callable)PROCESS_INFORMATIONS_TASK);
    }

    static HeapHistogram collectGlobalHeapHistogram() throws IOException, InterruptedException, ExecutionException {
        Map heapHistograms = RemoteCallHelper.collectDataByNodeName((Callable)HEAP_HISTOGRAM_TASK);
        HeapHistogram heapHistoTotal = null;
        for (HeapHistogram heapHisto : heapHistograms.values()) {
            if (heapHistoTotal == null) {
                heapHistoTotal = heapHisto;
                continue;
            }
            if (heapHisto == null) continue;
            heapHistoTotal.add(heapHisto);
        }
        if (heapHistoTotal == null) {
            throw new IllegalStateException(I18N.getString((String)"heap_histo_non_supporte"));
        }
        return heapHistoTotal;
    }

    static String forwardAction(String actionName, String sessionId, String threadId, String jobId) throws IOException, InterruptedException, ExecutionException {
        ActionTask task = new ActionTask(actionName, sessionId, threadId, jobId);
        Map messagesByNodeName = RemoteCallHelper.collectDataByNodeName((Callable)task);
        StringBuilder sb = new StringBuilder();
        for (String messageForReport : messagesByNodeName.values()) {
            if (messageForReport == null) continue;
            sb.append(messageForReport).append('\n');
        }
        String messageForReport = sb.length() == 0 ? null : sb.toString();
        return messageForReport;
    }
}

