/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.monitoring;

import hudson.Plugin;
import hudson.model.Hudson;
import hudson.util.PluginServletFilter;
import java.io.File;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import net.bull.javamelody.CounterRunListener;
import org.jvnet.hudson.plugins.monitoring.HudsonMonitoringFilter;
import org.jvnet.hudson.plugins.monitoring.NodesListener;

public class PluginImpl
extends Plugin {
    private ServletContext context;
    private HudsonMonitoringFilter filter;

    public void setServletContext(ServletContext context) {
        super.setServletContext(context);
        this.context = context;
    }

    public void start() throws Exception {
        super.start();
        if (this.isParameterUndefined("javamelody.system-actions-enabled")) {
            System.setProperty("javamelody.system-actions-enabled", "true");
        }
        if (this.isParameterUndefined("javamelody.no-database")) {
            System.setProperty("javamelody.no-database", "true");
        }
        if (this.isParameterUndefined("javamelody.storage-directory")) {
            System.setProperty("javamelody.storage-directory", "/" + new File(Hudson.getInstance().getRootDir(), "monitoring").getAbsolutePath());
        }
        if (this.isParameterUndefined("javamelody.analytics-id")) {
            System.setProperty("javamelody.analytics-id", "UA-1335263-7");
        }
        if (this.isParameterUndefined("javamelody.http-transform-pattern")) {
            System.setProperty("javamelody.http-transform-pattern", "/\\d+/|/site/.+|avadoc/.+|/ws/.+|obertura/.+|estReport/.+|iolations/file/.+|/user/.+|/static/\\w+/");
        }
        this.filter = new HudsonMonitoringFilter();
        PluginServletFilter.addFilter((Filter)this.filter);
    }

    private boolean isParameterUndefined(String key) {
        return System.getProperty(key) == null && this.context.getInitParameter(key) == null;
    }

    public void postInitialize() throws Exception {
        super.postInitialize();
        this.filter.getNodesCollector().init();
        new NodesListener(this.filter.getNodesCollector()).register();
        new CounterRunListener().register();
    }

    public void stop() throws Exception {
        this.filter.getNodesCollector().stop();
        super.stop();
    }
}

