package org.jvnet.hudson.plugins.monitoring;

import hudson.Plugin;
import hudson.util.PluginServletFilter;

/**
 * Entry point of the plugin.
 *
 * <p>
 * There must be one {@link Plugin} class in each plugin.
 * See javadoc of {@link Plugin} for more about what can be done on this class.
 *
 * @author Emeric Vernat
 */
public class PluginImpl extends Plugin {

  @Override
  public void start() throws Exception {
    super.start();
	
	// on active les actions systmes (gc, heap dump, histogramme mmoire, processus...), sauf si l'administrateur a dit diffremment
	if (System.getProperty("javamelody.system-actions-enabled") == null) {
		System.setProperty("javamelody.system-actions-enabled", "true");
	}
	// on dsactive les statistiques sql puisqu'il n'y en aura pas
	if (System.getProperty("javamelody.displayed-counters") == null) {
		System.setProperty("javamelody.displayed-counters", "http,error,log");
	}
	// le rpertoire de stockage est dans le rpertoire de hudson au lieu d'tre dans le rpertoire temporaire
	// ("/" initial ncessaire sous windows pour javamelody v1.8.1)
	if (System.getProperty("javamelody.storage-directory") == null && System.getenv("HUDSON_HOME") != null) {
		System.setProperty("javamelody.storage-directory", "/" + System.getenv("HUDSON_HOME") + "/monitoring");
	}
	// google-analytics pour connatre le nombre d'installations actives et pour connatre les fonctions les plus utilises
	if (System.getProperty("javamelody.analytics-id") == null) {
		System.setProperty("javamelody.analytics-id", "UA-1335263-7");
	}
	
	PluginServletFilter.addFilter(new net.bull.javamelody.MonitoringFilter());
	
	// TODO on ne peut pas ajouter aussi un SessionListener comme dans un web.xml ?
	// TODO il faudrait enlever used jdbc connections & active jdbc connections qui ne servent pas pour hudson
	// TODO on pourrait vrifier si la page "/manage" est appele et ajouter un lien "/monitoring" dans le flux html avant <a href="load-statistics">
	// mais pour l'instant on se contentera d'ajouter un lien dans la liste des plugins disponibles ou installs (index.jelly)
  }
}
