/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.msbuild;

import hudson.Launcher;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsBuildBuilder
extends Builder {
    private final String msBuildFile;
    private final String cmdLineArgs;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public MsBuildBuilder(String msBuildFile, String cmdLineArgs) {
        this.msBuildFile = msBuildFile == null || msBuildFile.trim().length() == 0 ? "" : msBuildFile;
        this.cmdLineArgs = cmdLineArgs == null || cmdLineArgs.trim().length() == 0 ? "" : cmdLineArgs;
    }

    public String getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    public String getMsBuildFile() {
        return this.msBuildFile;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        String msbuildExe;
        Project proj = (Project)build.getProject();
        ArgumentListBuilder args = new ArgumentListBuilder();
        listener.getLogger().println("Path To MSBuild.exe: " + DESCRIPTOR.getPathToMsBuild());
        String execName = msbuildExe = DESCRIPTOR.getPathToMsBuild();
        args.add(execName);
        String normalizedTarget = this.cmdLineArgs.replaceAll("[\t\r\n]+", " ");
        if (normalizedTarget.trim().length() > 0) {
            args.addTokenized(normalizedTarget);
        }
        if (this.msBuildFile != null && this.msBuildFile.trim().length() > 0) {
            args.add(this.msBuildFile);
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        listener.getLogger().println("Executing command: " + args.toString());
        Map env = build.getEnvVars();
        try {
            int r = launcher.launch(args.toCommandArray(), env, (OutputStream)listener.getLogger(), proj.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        public static String PARAMETERNAME_PATH_TO_MSBUILD = "pathToMsBuild";
        private static String DEFAULT_PATH_TO_MSBUILD = "msbuild.exe";
        private String pathToMsBuild;

        DescriptorImpl() {
            super(MsBuildBuilder.class);
            this.load();
            if (this.pathToMsBuild == null || this.pathToMsBuild.length() == 0) {
                this.pathToMsBuild = DEFAULT_PATH_TO_MSBUILD;
                this.save();
            }
        }

        public String getDisplayName() {
            return "Build a Visual Studio project or solution using MSBuild.";
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.pathToMsBuild = req.getParameter("descriptor." + PARAMETERNAME_PATH_TO_MSBUILD);
            if (this.pathToMsBuild == null || this.pathToMsBuild.length() == 0) {
                this.pathToMsBuild = DEFAULT_PATH_TO_MSBUILD;
            }
            this.save();
            return true;
        }

        public String getPathToMsBuild() {
            return this.pathToMsBuild;
        }

        public Builder newInstance(StaplerRequest arg0, JSONObject arg1) throws Descriptor.FormException {
            String buildFile = arg1.getString("msBuildFile");
            String cmdLineArg = arg1.getString("cmdLineArgs");
            MsBuildBuilder builder = new MsBuildBuilder(buildFile, cmdLineArg);
            return builder;
        }
    }
}

