/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mstest;

import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.agent.AbortException;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.mstest.MSTestPublisher;
import hudson.plugins.mstest.MSTestReportConverter;
import hudson.plugins.mstest.MSTestTransformer;
import hudson.tasks.Publisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSTestPublisher
extends Publisher
implements Serializable {
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();
    private String testResultsFile;

    public MSTestPublisher(String testResultsFile) {
        this.testResultsFile = testResultsFile;
    }

    public String getTestResultsTrxFile() {
        return this.testResultsFile;
    }

    public Action getProjectAction(Project project) {
        TestResultProjectAction action = (TestResultProjectAction)project.getAction(TestResultProjectAction.class);
        if (action == null) {
            return new TestResultProjectAction((AbstractProject)project);
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean result = true;
        try {
            listener.getLogger().println("Processing tests results in file " + this.testResultsFile);
            MSTestTransformer transformer = new MSTestTransformer(this.testResultsFile, new MSTestReportConverter(), listener);
            result = (Boolean)build.getProject().getWorkspace().act((FilePath.FileCallable)transformer);
            if (result) {
                result = this.recordTestResult("temporary-junit-reports/TEST-*.xml", build, listener);
                build.getProject().getWorkspace().child("temporary-junit-reports").deleteRecursive();
            }
        }
        catch (TransformerException te) {
            throw new AbortException("Could not read the XSL XML file. Please report this issue to the plugin author", (Exception)te);
        }
        return result;
    }

    private boolean recordTestResult(String junitFilePattern, AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException, IOException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            TestResult existingTestResults = null;
            if (existingAction != null) {
                existingTestResults = existingAction.getResult();
            }
            TestResult result = this.getTestResult(junitFilePattern, build, existingTestResults, buildTime);
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                new AbortException("None of the test reports contained any result");
            }
        }
        catch (AbortException e) {
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
        if (action.getResult().getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private TestResult getTestResult(String junitFilePattern, AbstractBuild<?, ?> build, TestResult existingTestResults, long buildTime) throws IOException, InterruptedException {
        TestResult result = (TestResult)build.getProject().getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

