/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mstest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;

public class MSTestReportConverter
implements Serializable {
    private static final String JUNIT_OUTPUT_FILE_STR = "TEST-mstest.xml";
    public static final String MSTEST_TO_JUNIT_XSLFILE_STR = "mstest-to-junit.xsl";
    private transient boolean xslIsInitialized;
    private transient Transformer mstestTransformer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(InputStream mstestFileStream, File junitOutputPath) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        this.initialize();
        File junitTargetFile = new File(junitOutputPath, JUNIT_OUTPUT_FILE_STR);
        FileOutputStream fileOutputStream = new FileOutputStream(junitTargetFile);
        try {
            this.mstestTransformer.transform(new StreamSource(mstestFileStream), new StreamResult(fileOutputStream));
        }
        finally {
            fileOutputStream.close();
        }
    }

    private void initialize() throws TransformerFactoryConfigurationError, TransformerConfigurationException, ParserConfigurationException {
        if (!this.xslIsInitialized) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.mstestTransformer = transformerFactory.newTransformer(new StreamSource(this.getClass().getResourceAsStream(MSTEST_TO_JUNIT_XSLFILE_STR)));
            this.xslIsInitialized = true;
        }
    }
}

