/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mstest;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.plugins.mstest.MSTestReportConverter;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSTestTransformer
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JUNIT_REPORTS_PATH = "temporary-junit-reports";
    private BuildListener listener;
    private final String testResultsFile;
    private MSTestReportConverter unitReportTransformer;

    public MSTestTransformer(String testResults, MSTestReportConverter unitReportTransformer, BuildListener listener) throws TransformerException {
        this.testResultsFile = testResults;
        this.unitReportTransformer = unitReportTransformer;
        this.listener = listener;
    }

    public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
        Boolean retValue = Boolean.TRUE;
        File junitOutputPath = new File(ws, JUNIT_REPORTS_PATH);
        junitOutputPath.mkdirs();
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(new File(ws, this.testResultsFile));
        }
        catch (FileNotFoundException e) {
            this.listener.fatalError("No MSTest TRX test report files were found. Configuration error?");
            return Boolean.FALSE;
        }
        try {
            this.unitReportTransformer.transform((InputStream)fileStream, junitOutputPath);
        }
        catch (TransformerException te) {
            throw new IOException2("Could not transform the MSTest report. Please report this issue to the plugin author", (Throwable)te);
        }
        catch (SAXException se) {
            throw new IOException2("Could not transform the MSTest report. Please report this issue to the plugin author", (Throwable)se);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException2("Could not initalize the XML parser. Please report this issue to the plugin author", (Throwable)pce);
        }
        finally {
            if (fileStream != null) {
                fileStream.close();
            }
        }
        return retValue;
    }
}

