/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mysql;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.plugins.mysql.Messages;
import hudson.plugins.mysql.MySQLAuthenticationException;
import hudson.plugins.mysql.MySQLUserDetail;
import hudson.plugins.mysql.crypt.Cipher;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class MySQLSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private static final Logger LOGGER = Logger.getLogger(MySQLSecurityRealm.class.getName());
    private String myServer;
    private String myUsername;
    private String myPassword;
    private String myDatabase;
    private String myDataTable;
    private String myUserField;
    private String myPassField;
    private String myPort;
    private String myCondition;
    private String encryption;

    @DataBoundConstructor
    public MySQLSecurityRealm(String myServer, String myUsername, String myPassword, String myPort, String myDatabase, String myDataTable, String myUserField, String myPassField, String myCondition, String encryption) {
        this.myServer = Util.fixEmptyAndTrim((String)myServer);
        this.myUsername = Util.fixEmptyAndTrim((String)myUsername);
        this.myPassword = Util.fixEmptyAndTrim((String)myPassword);
        this.myPort = Util.fixEmptyAndTrim((String)myPort);
        if (myPort == null || myPort.equals("")) {
            myPort = "3306";
        }
        this.myPort = myPort;
        this.myDatabase = Util.fixEmptyAndTrim((String)myDatabase);
        this.myCondition = Util.fixEmptyAndTrim((String)myCondition);
        this.myDataTable = Util.fixEmptyAndTrim((String)myDataTable);
        this.myUserField = Util.fixEmptyAndTrim((String)myUserField);
        this.myPassField = Util.fixEmptyAndTrim((String)myPassField);
        this.encryption = encryption;
    }

    @Extension
    public static DescriptorImpl install() {
        return new DescriptorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserDetails authenticate(String username, String password) throws AuthenticationException {
        MySQLUserDetail userDetails;
        block16: {
            userDetails = null;
            String connectionString = "jdbc:mysql://" + this.myServer + "/" + this.myDatabase;
            LOGGER.fine("MySQLSecurity: Connection String - " + connectionString);
            Connection conn = null;
            try {
                Class.forName("com.mysql.jdbc.Driver").newInstance();
                conn = DriverManager.getConnection(connectionString, this.myUsername, this.myPassword);
                LOGGER.info("MySQLSecurity: Connection established.");
                String userQuery = "SELECT * FROM " + this.myDataTable + " WHERE " + this.myUserField + " = ?";
                PreparedStatement statement = conn.prepareStatement(userQuery);
                statement.setString(1, this.myDataTable);
                LOGGER.fine("MySQLSecurity: Query Info - ");
                LOGGER.fine("- Table: " + this.myDataTable);
                LOGGER.fine("- User Field: " + this.myUserField);
                LOGGER.fine("- Username: " + this.myUsername);
                statement.setString(1, username);
                ResultSet results = statement.executeQuery();
                LOGGER.fine("MySQLSecurity: Query executed.");
                if (results.first()) {
                    Cipher cipher;
                    String storedPassword = results.getString(this.myPassField);
                    if (this.encryption.equals("Crypt")) {
                        String salt = storedPassword.substring(0, 2);
                        cipher = new Cipher(this.encryption, salt);
                    } else {
                        cipher = new Cipher(this.encryption);
                    }
                    String encryptedPassword = cipher.encode(password.trim());
                    LOGGER.fine("Encrypted Password: " + encryptedPassword);
                    LOGGER.fine("Stored Password: " + storedPassword);
                    if (!storedPassword.equals(encryptedPassword)) {
                        LOGGER.warning("MySQLSecurity: Invalid Username or Password");
                        throw new MySQLAuthenticationException("Invalid Username or Password");
                    }
                    HashSet<GrantedAuthority> groups = new HashSet<GrantedAuthority>();
                    groups.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
                    userDetails = new MySQLUserDetail(username, encryptedPassword, true, true, true, true, groups.toArray(new GrantedAuthority[groups.size()]));
                    break block16;
                }
                LOGGER.warning("MySQLSecurity: Invalid Username or Password");
                throw new MySQLAuthenticationException("Invalid Username or Password");
            }
            catch (Exception e) {
                LOGGER.warning("MySQLSecurity Realm Error: " + e.getLocalizedMessage());
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                        LOGGER.info("MySQLSecurity: Connection closed.");
                    }
                    catch (Exception ex) {}
                }
            }
        }
        return userDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        MySQLUserDetail user;
        block13: {
            user = null;
            String connectionString = "jdbc:mysql://" + this.myServer + "/" + this.myDatabase;
            LOGGER.info("MySQLSecurity: Connection String - " + connectionString);
            Connection conn = null;
            try {
                Class.forName("com.mysql.jdbc.Driver").newInstance();
                conn = DriverManager.getConnection(connectionString, this.myUsername, this.myPassword);
                LOGGER.info("MySQLSecurity: Connection established.");
                String userQuery = "SELECT * FROM " + this.myDataTable + " WHERE " + this.myUserField + " = ?";
                PreparedStatement statement = conn.prepareStatement(userQuery);
                statement.setString(1, username);
                ResultSet results = statement.executeQuery();
                LOGGER.fine("MySQLSecurity: Query executed.");
                if (results.first()) {
                    HashSet<GrantedAuthority> groups = new HashSet<GrantedAuthority>();
                    groups.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
                    user = new MySQLUserDetail(username, results.getString(this.myPassField), true, true, true, true, groups.toArray(new GrantedAuthority[groups.size()]));
                    break block13;
                }
                LOGGER.warning("MySQLSecurity: Invalid Username or Password");
                throw new UsernameNotFoundException("MySQL: User not found");
            }
            catch (Exception e) {
                LOGGER.warning("MySQLSecurity Realm Error: " + e.getLocalizedMessage());
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                        LOGGER.info("MySQLSecurity: Connection closed.");
                    }
                    catch (Exception ex) {}
                }
            }
        }
        return user;
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        LOGGER.warning("ERROR: Group lookup is not supported.");
        throw new UsernameNotFoundException("MySQLSecurityRealm: Non-supported function");
    }

    public String getMyServer() {
        return this.myServer;
    }

    public String getMyUsername() {
        return this.myUsername;
    }

    public String getMyPassword() {
        return this.myPassword;
    }

    public String getMyDatabase() {
        return this.myDatabase;
    }

    public String getMyDataTable() {
        return this.myDataTable;
    }

    public String getMyUserField() {
        return this.myUserField;
    }

    public String getMyPassField() {
        return this.myPassField;
    }

    public String getMyPort() {
        return this.myPort;
    }

    public String getMyCondition() {
        return this.myCondition;
    }

    public String getEncryption() {
        return this.encryption;
    }

    class Authenticator
    extends AbstractUserDetailsAuthenticationProvider {
        Authenticator() {
        }

        protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        }

        protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
            return MySQLSecurityRealm.this.authenticate(username, authentication.getCredentials().toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getHelpFile() {
            return "/plugin/mysql-auth/help/overview.html";
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }
    }
}

