/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mysql.crypt;

import hudson.plugins.mysql.crypt.EncryptionException;
import hudson.plugins.mysql.crypt.JCrypt;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Cipher {
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";
    public static final String SHA256 = "SHA-256";
    public static final String SHA384 = "SHA-384";
    public static final String SHA512 = "SHA-512";
    public static final String CRYPT = "Crypt";
    private String encryptionMethod;
    private String salt;

    public Cipher(String type) {
        this.encryptionMethod = type;
        this.salt = null;
    }

    public Cipher(String type, String salt) {
        this.encryptionMethod = type;
        this.salt = salt;
    }

    public String encode(String plaintext) throws EncryptionException {
        block5: {
            block4: {
                if (this.salt != null) break block4;
                if (!this.encryptionMethod.equals(CRYPT)) break block5;
            }
            return JCrypt.crypt(this.salt, plaintext);
        }
        try {
            MessageDigest md = MessageDigest.getInstance(this.encryptionMethod);
            md.reset();
            byte[] textBytes = plaintext.getBytes();
            md.update(textBytes);
            return md.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptionException();
        }
    }
}

