/*
 * Decompiled with CFR 0.152.
 */
package com.chikli.hudson.plugin.naginator;

import com.chikli.hudson.plugin.naginator.NaginatorCause;
import com.chikli.hudson.plugin.naginator.NaginatorPublisher;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaginatorPublisher
extends Notifier {
    private final String regexpForRerun;
    private final boolean rerunIfUnstable;
    private final boolean checkRegexp;
    private boolean debug = false;
    private static final Logger LOGGER = Logger.getLogger(NaginatorPublisher.class.getName());

    @DataBoundConstructor
    public NaginatorPublisher(String regexpForRerun, boolean rerunIfUnstable, boolean checkRegexp) {
        this.regexpForRerun = regexpForRerun;
        this.checkRegexp = checkRegexp;
        this.rerunIfUnstable = rerunIfUnstable;
    }

    public boolean isRerunIfUnstable() {
        return this.rerunIfUnstable;
    }

    public boolean isCheckRegexp() {
        return this.checkRegexp;
    }

    public String getRegexpForRerun() {
        return this.regexpForRerun;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult() == Result.SUCCESS) {
            return true;
        }
        if (!this.rerunIfUnstable && build.getResult() == Result.UNSTABLE) {
            return true;
        }
        if (this.checkRegexp) {
            if (this.debug) {
                LOGGER.log(Level.WARNING, "Got checkRegexp == true");
            }
            if (this.regexpForRerun != null && !this.regexpForRerun.equals("")) {
                if (this.debug) {
                    LOGGER.log(Level.WARNING, "regexpForRerun - " + this.regexpForRerun);
                }
                try {
                    if (!this.parseLog(build.getLogFile(), this.regexpForRerun)) {
                        if (this.debug) {
                            LOGGER.log(Level.WARNING, "regexp not in logfile");
                        }
                        return true;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(listener.error("error while parsing logs for naginator - forcing rebuild."));
                }
            }
        }
        int n = 0;
        for (AbstractBuild b = build; b != null && b.getResult() != Result.SUCCESS && n < 60; n += 5, b = (AbstractBuild)b.getPreviousBuild()) {
        }
        if (this.debug) {
            LOGGER.log(Level.WARNING, "about to try to schedule a build");
        }
        return this.scheduleBuild(build, n);
    }

    public boolean scheduleBuild(AbstractBuild<?, ?> build, int n) throws InterruptedException, IOException {
        if (this.debug) {
            try {
                build.setDescription("rebuild");
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "couldn't set description: " + e.getStackTrace());
            }
            return true;
        }
        return build.getProject().scheduleBuild(n * 60, (Cause)new NaginatorCause());
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    private boolean parseLog(File logFile, String regexp) throws IOException, InterruptedException {
        String line;
        if (regexp == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(regexp);
        BufferedReader reader = new BufferedReader(new FileReader(logFile));
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

