/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nant;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.nant.NantBuilder;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NantBuilder
extends Builder {
    private final String targets;
    private final String nantBuildFile;
    private final String nantName;
    private final String properties;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl(null);

    @DataBoundConstructor
    public NantBuilder(String nantBuildFile, String nantName, String targets, String properties) {
        this.nantBuildFile = nantBuildFile == null || nantBuildFile.trim().length() == 0 ? "" : nantBuildFile;
        this.nantName = nantName;
        this.targets = targets == null || targets.trim().length() == 0 ? "" : targets;
        this.properties = Util.fixEmptyAndTrim((String)properties);
    }

    public NantInstallation getNant() {
        for (NantInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.nantName == null || !i.getName().equals(this.nantName)) continue;
            return i;
        }
        return null;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getNantBuildFile() {
        return this.nantBuildFile;
    }

    public String getNantName() {
        return this.nantName;
    }

    public String getProperties() {
        return this.properties;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        VariableResolver vr = build.getBuildVariableResolver();
        String execName = launcher.isUnix() ? "nant" : "NAnt.exe";
        NantInstallation ni = this.getNant();
        if (ni == null) {
            args.add(execName);
        } else {
            args.add(ni.getExecutable(launcher));
        }
        if (this.nantBuildFile != null && this.nantBuildFile.trim().length() > 0) {
            args.add("-buildfile:" + this.nantBuildFile);
        }
        args.addKeyValuePairsFromPropertyString("-D:", this.properties, vr);
        String normalizedTarget = this.targets.replaceAll("[\t\r\n]+", " ");
        if (normalizedTarget.trim().length() > 0) {
            args.addTokenized(normalizedTarget);
        }
        if (!launcher.isUnix()) {
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
            args = new ArgumentListBuilder().add(new String[]{"cmd.exe", "/C"}).addQuoted(args.toStringWithQuote());
        }
        listener.getLogger().println("Executing command: " + args.toString());
        EnvVars env = build.getEnvironment((TaskListener)listener);
        try {
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }
}

