/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nant;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.nant.Messages;
import hudson.remoting.Callable;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NantBuilder
extends Builder {
    private final String targets;
    private final String nantBuildFile;
    private final String nantName;
    private final String properties;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public NantBuilder(String nantBuildFile, String nantName, String targets, String properties) {
        this.nantBuildFile = nantBuildFile == null || nantBuildFile.trim().length() == 0 ? "" : nantBuildFile;
        this.nantName = nantName;
        this.targets = targets == null || targets.trim().length() == 0 ? "" : targets;
        this.properties = Util.fixEmptyAndTrim((String)properties);
    }

    public NantInstallation getNant() {
        for (NantInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.nantName == null || !i.getName().equals(this.nantName)) continue;
            return i;
        }
        return null;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getNantBuildFile() {
        return this.nantBuildFile;
    }

    public String getNantName() {
        return this.nantName;
    }

    public String getProperties() {
        return this.properties;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        VariableResolver vr = build.getBuildVariableResolver();
        String execName = NantInstallation.getExecutableName();
        NantInstallation ni = this.getNant();
        if (ni == null) {
            args.add(launcher.isUnix() ? "nant" : "NAnt.exe");
        } else {
            args.add(ni.getExecutable(launcher));
        }
        if (this.nantBuildFile != null && this.nantBuildFile.trim().length() > 0) {
            args.add("-buildfile:" + this.nantBuildFile);
        }
        args.addKeyValuePairsFromPropertyString("-D:", this.properties, vr);
        String normalizedTarget = this.targets.replaceAll("[\t\r\n]+", " ");
        if (normalizedTarget.trim().length() > 0) {
            args.addTokenized(normalizedTarget);
        }
        if (!launcher.isUnix()) {
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
            args = new ArgumentListBuilder().add(new String[]{"cmd.exe", "/C"}).addQuoted(args.toStringWithQuote());
        }
        listener.getLogger().println("Executing command: " + args.toString());
        EnvVars env = build.getEnvironment((TaskListener)listener);
        try {
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class NantInstallation
    implements Serializable {
        private final String name;
        private final String nantHome;
        private static final long serialVersionUID = 1L;

        public NantInstallation(String name, String nantHome) {
            this.name = name;
            this.nantHome = nantHome;
        }

        public String getNantHome() {
            return this.nantHome;
        }

        public String getName() {
            return this.name;
        }

        public String getExecutable(Launcher launcher) throws IOException, InterruptedException {
            return (String)launcher.getChannel().call((Callable)new Callable<String, IOException>(){

                public String call() throws IOException {
                    File exe = NantInstallation.this.getExecutableFile();
                    if (exe.exists()) {
                        return exe.getPath();
                    }
                    throw new IOException(exe.getPath() + " doesn't exist");
                }
            });
        }

        public File getExecutableFile() {
            return new File(this.getNantHome(), "bin/" + NantInstallation.getExecutableName());
        }

        public static String getExecutableName() {
            if (Functions.isWindows()) {
                return "NAnt.exe";
            }
            return "nant";
        }

        public boolean getExists() throws IOException, InterruptedException {
            Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(TaskListener.NULL);
            return (Boolean)launcher.getChannel().call((Callable)new Callable<Boolean, IOException>(){

                public Boolean call() throws IOException {
                    return NantInstallation.this.getExecutableFile().exists();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        public static String PARAMETERNAME_PATH_TO_NANT = "pathToNant";
        private volatile NantInstallation[] installations = new NantInstallation[0];

        private DescriptorImpl() {
            super(NantBuilder.class);
            this.load();
        }

        protected void convert(Map<String, Object> oldPropertyBag) {
            if (oldPropertyBag.containsKey("installations")) {
                this.installations = (NantInstallation[])oldPropertyBag.get("installations");
            }
        }

        public String getDisplayName() {
            return Messages.NantBuilder_DisplayName();
        }

        public NantInstallation[] getInstallations() {
            return this.installations;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String[] names = req.getParameterValues("nant_name");
            String[] homes = req.getParameterValues("nant_home");
            int len = names != null && homes != null ? Math.min(names.length, homes.length) : 0;
            NantInstallation[] insts = new NantInstallation[len];
            for (int i = 0; i < len; ++i) {
                if (names[i].length() == 0 || homes[i].length() == 0) continue;
                insts[i] = new NantInstallation(names[i], homes[i]);
            }
            this.installations = insts;
            this.save();
            return true;
        }

        public FormValidation doCheckNantHome(@QueryParameter String value) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            File f = new File(Util.fixNull((String)value));
            if (!f.isDirectory()) {
                return FormValidation.error((String)(f + " is not a directory"));
            }
            NantInstallation nantInstall = new NantInstallation("", f.getAbsolutePath());
            if (!nantInstall.getExecutableFile().exists()) {
                return FormValidation.error((String)(f + " is not a NAnt installation directory."));
            }
            return FormValidation.ok();
        }
    }
}

