/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.nextbuildnumber;

import hudson.model.Action;
import hudson.model.Job;
import hudson.security.Permission;
import java.io.IOException;
import javax.servlet.ServletException;
import org.jvnet.hudson.plugins.nextbuildnumber.Messages;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class NextBuildNumberAction
implements Action {
    private final Job job;

    NextBuildNumberAction(Job job) {
        this.job = job;
    }

    public String getIconFileName() {
        if (this.job.getACL().hasPermission(this.getPermission())) {
            return "next.gif";
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.DisplayName();
    }

    public String getUrlName() {
        return "nextbuildnumber";
    }

    public Job getJob() {
        return this.job;
    }

    public Permission getPermission() {
        return Job.CONFIGURE;
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        this.job.getACL().checkPermission(this.getPermission());
        try {
            int buildNumber = Integer.parseInt(req.getParameter("nextBuildNumber"));
            this.job.updateNextBuildNumber(buildNumber);
            resp.sendRedirect2(this.job.getAbsoluteUrl());
        }
        catch (NumberFormatException e) {
            throw new ServletException("Build number must be an integer", (Throwable)e);
        }
    }
}

