/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.nextbuildnumber;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.TransientProjectActionFactory;
import hudson.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletException;
import org.jvnet.hudson.plugins.nextbuildnumber.Messages;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class NextBuildNumberAction
implements Action {
    private final Job job;

    NextBuildNumberAction(Job job) {
        this.job = job;
    }

    public String getIconFileName() {
        if (this.job.getACL().hasPermission(this.getPermission())) {
            return "next.gif";
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.DisplayName();
    }

    public String getUrlName() {
        return "nextbuildnumber";
    }

    public Job getJob() {
        return this.job;
    }

    public Permission getPermission() {
        return Job.CONFIGURE;
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        this.job.getACL().checkPermission(this.getPermission());
        try {
            int buildNumber = Integer.parseInt(req.getParameter("nextBuildNumber"));
            this.job.updateNextBuildNumber(buildNumber);
            resp.sendRedirect2(this.job.getAbsoluteUrl());
        }
        catch (NumberFormatException e) {
            throw new ServletException("Build number must be an integer", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActionInjector
    extends TransientProjectActionFactory {
        public Collection<NextBuildNumberAction> createFor(AbstractProject p) {
            ArrayList<NextBuildNumberAction> list = new ArrayList<NextBuildNumberAction>();
            list.add(new NextBuildNumberAction((Job)p));
            return list;
        }
    }
}

