/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nsiq;

import hudson.FilePath;
import hudson.plugins.nsiq.Encoding;
import hudson.plugins.nsiq.NSiqUtil;
import hudson.plugins.nsiq.SourcePainter;
import java.io.IOException;

public class NSiqSrc {
    private final FilePath srcFile;

    public NSiqSrc(FilePath srcFile) {
        this.srcFile = srcFile;
    }

    public FilePath getSrcFile() {
        return this.srcFile;
    }

    public String getFileType() {
        if (this.srcFile == null) {
            return "plain";
        }
        if (this.srcFile.getName().endsWith(".java")) {
            return "java";
        }
        return "cpp";
    }

    public String getFileContent(Encoding encoding) throws IOException {
        if (this.srcFile == null) {
            return "No file is avaliable";
        }
        return new SourcePainter().paint(this.srcFile, encoding);
    }

    public String getBaseURL() {
        return NSiqUtil.getHudsonBaseURL();
    }
}

