/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nsiq;

import hudson.model.Build;
import hudson.model.Descriptor;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Project;
import hudson.plugins.nsiq.NSiqAware;
import hudson.plugins.nsiq.NSiqBuilder;
import hudson.plugins.nsiq.NSiqPublisher;
import hudson.plugins.nsiq.NSiqTarget;
import hudson.plugins.nsiq.NSiqUtil;
import hudson.plugins.nsiq.model.NSiqSummary;
import hudson.tasks.Builder;
import hudson.util.Graph;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class NSiqBuildAction
implements HealthReportingAction,
StaplerProxy,
NSiqAware {
    private static Logger logger = Logger.getLogger(NSiqBuildAction.class.getName());
    public final Build<?, ?> owner;
    private final double lowRatio;
    private final double highRatio;
    private final NSiqSummary summary;
    private transient WeakReference<NSiqTarget> target;
    private HealthReport healthReport = null;

    private NSiqBuildAction(Build<?, ?> build, NSiqSummary summary, NSiqTarget target, double lowRatio, double highRatio) {
        this.owner = build;
        this.summary = summary;
        this.target = new WeakReference<NSiqTarget>(target);
        this.lowRatio = lowRatio;
        this.highRatio = highRatio;
    }

    public static NSiqBuildAction load(Build<?, ?> build, NSiqSummary summary, NSiqTarget target, double lowRatio, double highRatio) {
        return new NSiqBuildAction(build, summary, target, lowRatio, highRatio);
    }

    private NSiqPublisher getPublisher() {
        return (NSiqPublisher)((Project)this.owner.getProject()).getPublisher((Descriptor)NSiqPublisher.DESCRIPTOR);
    }

    private NSiqBuilder getBuilder() {
        for (Builder p : ((Project)this.owner.getProject()).getBuilders()) {
            if (p.getDescriptor() != NSiqBuilder.DESCRIPTOR) continue;
            return (NSiqBuilder)p;
        }
        return null;
    }

    public String getSrc() {
        return this.getBuilder().getSrcDir();
    }

    public boolean isDailyView() {
        return this.getPublisher().isDailyView();
    }

    private double getLowValue() {
        return (double)this.summary.getLow() * 100.0 / (double)(this.summary.getTotal() == 0 ? 1 : this.summary.getTotal());
    }

    private double getHighValue() {
        return (double)this.summary.getHigh() * 100.0 / (double)(this.summary.getTotal() == 0 ? 1 : this.summary.getTotal());
    }

    public String getLowRatio() {
        return NSiqUtil.getFormattedComplexity((double)this.getLowValue());
    }

    public String getHighRatio() {
        return NSiqUtil.getFormattedComplexity((double)this.getHighValue());
    }

    private int getPercent(double value, double configured) {
        int percent = 100;
        if (Double.compare(value, configured) >= 0) {
            for (int i = 5; i > 0; --i) {
                if (!(value > configured * (double)i)) continue;
                percent = (5 - i) * 15;
                break;
            }
        }
        return percent;
    }

    private int getPercent() {
        int highPercent;
        int lowPercent = this.getPercent(this.getLowValue(), this.lowRatio);
        return lowPercent < (highPercent = this.getPercent(this.getHighValue(), this.highRatio)) ? lowPercent : highPercent;
    }

    public HealthReport getBuildHealth() {
        if (this.healthReport != null) {
            return this.healthReport;
        }
        StringBuffer sb = new StringBuffer("N'SIQ Collector: ");
        sb.append("over 10: ");
        sb.append(this.getLowRatio());
        sb.append("(metric=" + NSiqUtil.getFormattedComplexity((double)this.lowRatio) + ")");
        sb.append(", ");
        sb.append("over 30: ");
        sb.append(this.getHighRatio());
        sb.append("(metric=" + NSiqUtil.getFormattedComplexity((double)this.highRatio) + ")");
        this.healthReport = new HealthReport(this.getPercent(), sb.toString());
        return this.healthReport;
    }

    public String getDisplayName() {
        return "N'SIQ Collector";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "nsiq";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSiqTarget getTarget() {
        NSiqTarget nsiqTarget;
        if (this.target != null && (nsiqTarget = (NSiqTarget)this.target.get()) != null) {
            return nsiqTarget;
        }
        nsiqTarget = null;
        NSiqBuildAction nSiqBuildAction = this;
        synchronized (nSiqBuildAction) {
            try {
                nsiqTarget = (NSiqTarget)NSiqUtil.getDataFile((Build)this.owner).read();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.toString());
            }
            if (nsiqTarget != null) {
                nsiqTarget.setOwner(this.owner);
                for (NSiqTarget file : nsiqTarget.getChildren().values()) {
                    file.setOwner(this.owner);
                    file.setParent(nsiqTarget);
                    for (NSiqTarget function : file.getChildren().values()) {
                        function.setOwner(this.owner);
                        function.setParent(file);
                    }
                }
                this.target = new WeakReference<NSiqTarget>(nsiqTarget);
                return nsiqTarget;
            }
            return null;
        }
    }

    public NSiqSummary getSummary() {
        return this.summary;
    }

    public NSiqBuildAction getPreviousResult() {
        return NSiqBuildAction.getPreviousResult((Build)this.owner);
    }

    public boolean isOverView() {
        return this.getPublisher().isOverView();
    }

    static NSiqBuildAction getPreviousResult(Build<?, ?> owner) {
        NSiqBuildAction action;
        Build build = owner;
        do {
            if ((build = (Build)build.getPreviousNotFailedBuild()) != null) continue;
            return null;
        } while ((action = (NSiqBuildAction)build.getAction(NSiqBuildAction.class)) == null);
        return action;
    }

    public long getTimestamp() {
        return this.owner.getTimestamp().getTimeInMillis();
    }

    public Graph getLocDistGraph() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Graph getLocGraph() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Graph getComplexityGraph() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

