/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nsiq;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.nsiq.Encoding;
import hudson.plugins.nsiq.NSiqAware;
import hudson.plugins.nsiq.NSiqBuildAction;
import hudson.plugins.nsiq.NSiqProjectAction;
import hudson.plugins.nsiq.NSiqPublisher;
import hudson.plugins.nsiq.NSiqTarget;
import hudson.plugins.nsiq.NSiqUtil;
import hudson.plugins.nsiq.model.NSiqSummary;
import hudson.plugins.nsiq.parser.ComplexityParser;
import hudson.plugins.nsiq.parser.LocParser;
import hudson.plugins.nsiq.parser.NSiqResultParser;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSiqPublisher
extends Recorder
implements NSiqAware {
    private final double lowRatio;
    private final double highRatio;
    private boolean locView = true;
    private boolean complexityView = true;
    private boolean overView;
    private boolean dailyView;
    private final Encoding encoding;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public NSiqPublisher(double lowRatio, double highRatio, boolean locView, boolean complexityView, boolean overView, boolean dailyView, Encoding encoding) {
        this.lowRatio = lowRatio;
        this.highRatio = highRatio;
        this.locView = locView;
        this.complexityView = complexityView;
        this.overView = overView;
        this.dailyView = dailyView;
        this.encoding = encoding;
    }

    public boolean isLocView() {
        return this.locView;
    }

    public boolean isComplexityView() {
        return this.complexityView;
    }

    public boolean isOverView() {
        return this.overView;
    }

    public boolean isDailyView() {
        return this.dailyView;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.FAILURE)) {
            return false;
        }
        FilePath moduleRoot = build.getModuleRoots().length == 1 ? build.getModuleRoot() : build.getModuleRoot().getParent();
        FilePath locFile = NSiqUtil.getLocFile((FilePath)moduleRoot);
        FilePath complexityFile = NSiqUtil.getComplexityFile((FilePath)moduleRoot);
        if (!locFile.exists() || !complexityFile.exists()) {
            return false;
        }
        LocParser locParser = new LocParser(locFile);
        List locList = locParser.parse();
        ComplexityParser complexityParser = new ComplexityParser(complexityFile);
        List complexityList = complexityParser.parse();
        NSiqResultParser nsiqCollectorParser = new NSiqResultParser(locList, complexityList);
        List nsiqResult = nsiqCollectorParser.parse();
        NSiqSummary summary = nsiqCollectorParser.getSummary();
        NSiqTarget target = NSiqTarget.load(build, (List)nsiqResult);
        target.setOwner(null);
        NSiqUtil.getDataFile(build).write((Object)target);
        target.setOwner(build);
        locFile.delete();
        complexityFile.delete();
        NSiqBuildAction action = NSiqBuildAction.load(build, (NSiqSummary)summary, (NSiqTarget)target, (double)this.lowRatio, (double)this.highRatio);
        build.getActions().add(action);
        return true;
    }

    public Action getProjectAction(Project project) {
        return new NSiqProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Encoding getEncoding() {
        return this.encoding == null ? Encoding.UTF_8 : this.encoding;
    }

    static /* synthetic */ double access$000(NSiqPublisher x0) {
        return x0.lowRatio;
    }

    static /* synthetic */ double access$100(NSiqPublisher x0) {
        return x0.highRatio;
    }
}

