/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nsiq;

import hudson.FilePath;
import hudson.model.Build;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Run;
import hudson.plugins.nsiq.Constant;
import hudson.plugins.nsiq.NSiqAware;
import hudson.plugins.nsiq.NSiqBuildAction;
import hudson.plugins.nsiq.NSiqBuilder;
import hudson.plugins.nsiq.NSiqPublisher;
import hudson.plugins.nsiq.NSiqTarget;
import hudson.plugins.nsiq.NSiqUtil;
import hudson.plugins.nsiq.model.Complexity;
import hudson.plugins.nsiq.model.FileType;
import hudson.plugins.nsiq.model.Level;
import hudson.plugins.nsiq.model.NSiqResult;
import hudson.plugins.nsiq.model.NSiqSummary;
import hudson.tasks.Builder;
import hudson.util.Graph;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletException;
import org.apache.commons.lang.mutable.MutableInt;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSiqTarget
implements Serializable,
NSiqAware {
    private static final long serialVersionUID = 2951637921403461196L;
    private transient Build<?, ?> owner = null;
    private final String name;
    private final Level level;
    private final NSiqSummary summary = new NSiqSummary();
    private transient List<NSiqResult> nsiqResult;
    private NSiqResult itsNSiqResult;
    private transient NSiqTarget parent;
    private final Map<String, NSiqTarget> children = new LinkedHashMap();

    private NSiqTarget(Build<?, ?> owner, NSiqTarget parent, String name, Level level, List<NSiqResult> nsiqResult) {
        this.owner = owner;
        this.parent = parent;
        this.name = name;
        this.level = level;
        switch (4.$SwitchMap$hudson$plugins$nsiq$model$Level[level.ordinal()]) {
            case 1: {
                this.itsNSiqResult = null;
                break;
            }
            case 2: 
            case 3: {
                this.itsNSiqResult = nsiqResult.get(0);
            }
        }
        this.parseSummary(nsiqResult);
        if (level != Level.Function) {
            this.parseChildren(nsiqResult);
        }
    }

    public static NSiqTarget load(Build<?, ?> owner, List<NSiqResult> nsiqResult) {
        NSiqTarget target = new NSiqTarget(owner, null, null, Level.Directory, nsiqResult);
        return target;
    }

    public String getName() {
        return this.name;
    }

    public Build<?, ?> getOwner() {
        return this.owner;
    }

    public void setOwner(Build<?, ?> build) {
        this.owner = build;
    }

    public String getLevel() {
        return this.level.getName();
    }

    public NSiqTarget getParent() {
        return this.parent;
    }

    public Map<String, NSiqTarget> getChildren() {
        return this.children;
    }

    public Collection<NSiqTarget> getChildrenList() {
        return this.children.values();
    }

    public NSiqTarget getChild(String name) {
        return (NSiqTarget)this.children.get(name);
    }

    public NSiqSummary getSummary() {
        return this.summary;
    }

    public List<Complexity> getComplexityList() {
        if (this.getItsNSiqResult() != null) {
            return this.getItsNSiqResult().getFunctions();
        }
        return null;
    }

    private NSiqPublisher getPublisher() {
        return (NSiqPublisher)((Project)this.owner.getProject()).getPublisher((Descriptor)NSiqPublisher.DESCRIPTOR);
    }

    public boolean isLocView() {
        return this.getPublisher().isLocView();
    }

    public boolean isComplexityView() {
        return this.getPublisher().isComplexityView();
    }

    public boolean isOverView() {
        return this.getPublisher().isOverView();
    }

    private void parseSummary(List<NSiqResult> nsiqResults) {
        int total = 0;
        int high = 0;
        int low = 0;
        int comp = 0;
        int totalLoc = 0;
        int codeLoc = 0;
        HashMap<FileType, MutableInt> locPerType = new HashMap<FileType, MutableInt>();
        for (NSiqResult nsiq : nsiqResults) {
            totalLoc += nsiq.getTotalLoc();
            codeLoc += nsiq.getCodeLoc();
            MutableInt eachLocPerType = (MutableInt)locPerType.get(nsiq.geteType());
            if (eachLocPerType == null) {
                eachLocPerType = new MutableInt();
                locPerType.put(nsiq.geteType(), eachLocPerType);
            }
            eachLocPerType.add(nsiq.getCodeLoc());
            if (nsiq.getFunctions() == null) continue;
            for (Complexity complexity : nsiq.getFunctions()) {
                ++total;
                if (complexity.getComplexity() >= 30) {
                    ++high;
                }
                if (complexity.getComplexity() >= 10) {
                    ++low;
                }
                if (comp >= complexity.getComplexity()) continue;
                comp = complexity.getComplexity();
            }
        }
        this.summary.setTotal(total);
        this.summary.setHigh(high);
        this.summary.setLow(low);
        this.summary.setComplexity(comp);
        this.summary.setTotalLoc(totalLoc);
        this.summary.setCodeLoc(codeLoc);
        this.summary.setLocPerType(NSiqUtil.convertLangDistMap(locPerType));
    }

    public long getTimestamp() {
        return this.owner.getTimestamp().getTimeInMillis();
    }

    private void parseChildren(List<NSiqResult> nsiqResult) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (NSiqResult nsiq : nsiqResult) {
            treeSet.add(this.level == Level.Directory ? nsiq.getDir() : nsiq.getFile());
        }
        String[] sorted = treeSet.toArray(new String[treeSet.size()]);
        Arrays.sort(sorted, String.CASE_INSENSITIVE_ORDER);
        for (String name : sorted) {
            List childNSiqResult = this.getChildNSiqResult(name, nsiqResult);
            NSiqTarget childTarget = new NSiqTarget(this.owner, this, name, this.level == Level.Directory ? Level.File : Level.Function, childNSiqResult);
            this.children.put(name, childTarget);
        }
    }

    private List<NSiqResult> getChildNSiqResult(String name, List<NSiqResult> nsiqResult) {
        LinkedList<NSiqResult> result = new LinkedList<NSiqResult>();
        for (NSiqResult nsiq : nsiqResult) {
            if ((this.level != Level.Directory || !name.equals(nsiq.getDir())) && (this.level != Level.File || !name.equals(nsiq.getFile()))) continue;
            NSiqResult cloned = new NSiqResult();
            BeanUtils.copyProperties((Object)nsiq, (Object)cloned);
            result.add(cloned);
        }
        return result;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (this.level.equals((Object)Level.Function) && "raw".equals(token)) {
            return new RedirectSrc(this);
        }
        for (String name : this.children.keySet()) {
            if (!this.urlTransform(name).toLowerCase(Constant.LOCALE).equals(token.toLowerCase(Constant.LOCALE))) continue;
            return this.getChild(name);
        }
        return null;
    }

    public NSiqTarget getPreviousResult() {
        if (this.parent == null) {
            if (this.owner == null) {
                return null;
            }
            Run prevBuild = this.owner.getPreviousNotFailedBuild();
            if (prevBuild == null) {
                return null;
            }
            NSiqBuildAction action = null;
            while (prevBuild != null && null == (action = (NSiqBuildAction)prevBuild.getAction(NSiqBuildAction.class))) {
                prevBuild = prevBuild.getPreviousNotFailedBuild();
            }
            if (action == null) {
                return null;
            }
            return action.getTarget();
        }
        NSiqTarget prevParent = this.parent.getPreviousResult();
        return prevParent == null ? null : prevParent.getChild(this.name);
    }

    public String urlTransform(String name) {
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ('0' <= c && '9' >= c || 'A' <= c && 'Z' >= c || 'a' <= c && 'z' >= c) {
                buf.append(c);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    private NSiqBuilder getBuilder() {
        for (Builder p : ((Project)this.owner.getProject()).getBuilders()) {
            if (p.getDescriptor() != NSiqBuilder.DESCRIPTOR) continue;
            return (NSiqBuilder)p;
        }
        return null;
    }

    public String[] getSrc() {
        NSiqBuilder builder = this.getBuilder();
        if (builder == null) {
            return null;
        }
        return builder.getSrcDir().split(",");
    }

    public FilePath getSrcFile() throws InterruptedException, IOException {
        String dir = this.getItsNSiqResult().getDir();
        String file = this.getItsNSiqResult().getFile();
        for (FilePath moduleRoot : this.owner.getModuleRoots()) {
            for (String src : this.getSrc()) {
                FilePath path = moduleRoot.child(src.trim()).child(dir).child(file);
                if (!path.exists()) continue;
                return path;
            }
        }
        return null;
    }

    public Graph getLocGraph() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Graph getComplexityGraph() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Graph getLocDistGraph() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setItsNSiqResult(NSiqResult itsNSiqResult) {
        this.itsNSiqResult = itsNSiqResult;
    }

    public NSiqResult getItsNSiqResult() {
        if (this.itsNSiqResult == null && this.nsiqResult.size() > 0) {
            return (NSiqResult)this.nsiqResult.get(0);
        }
        return this.itsNSiqResult;
    }

    public void setParent(NSiqTarget parent) {
        this.parent = parent;
    }

    static /* synthetic */ NSiqPublisher access$000(NSiqTarget x0) {
        return x0.getPublisher();
    }

    static /* synthetic */ Build access$100(NSiqTarget x0) {
        return x0.owner;
    }
}

