/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nsiq;

import com.thoughtworks.xstream.XStream;
import hudson.FilePath;
import hudson.XmlFile;
import hudson.model.Build;
import hudson.model.Hudson;
import hudson.plugins.nsiq.model.FileType;
import hudson.util.ColorPalette;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.XStream2;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableInt;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NSiqUtil {
    public static String baseURL;

    private NSiqUtil() {
    }

    public static FilePath getLocFile(FilePath filePath) {
        return new FilePath(filePath, "loc.csv");
    }

    public static FilePath getComplexityFile(FilePath filePath) {
        return new FilePath(filePath, "complexity.csv");
    }

    public static XmlFile getDataFile(Build<?, ?> build) {
        File dir = build == null ? new File(System.getProperty("java.io.tmpdir")) : build.getRootDir();
        return new XmlFile((XStream)new XStream2(), new File(dir, "nsiqResult.xml"));
    }

    public static String getFormattedComplexity(double complexity) {
        return String.format("%.1f", complexity);
    }

    public static JFreeChart createLineChart(CategoryDataset dataset, String yAxis, int lower, int upper) {
        JFreeChart chart = ChartFactory.createLineChart(null, null, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        if (lower == Integer.MAX_VALUE) {
            lower = 0;
        }
        if (upper == Integer.MIN_VALUE) {
            upper = 0;
        }
        double lowerBound = (double)lower * 0.95;
        double upperBound = (double)upper * 1.05;
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerBound(lowerBound);
        rangeAxis.setUpperBound(upperBound);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setStroke((Stroke)new BasicStroke(2.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public static JFreeChart createStackChart(CategoryDataset dataset, String yAxis) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerBound(0.0);
        StackedAreaRenderer renderer = (StackedAreaRenderer)plot.getRenderer();
        plot.setRenderer((CategoryItemRenderer)renderer);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public static String getHudsonBaseURL() {
        if (baseURL == null) {
            baseURL = Hudson.getInstance().getRootUrlFromRequest();
        }
        return baseURL;
    }

    public static JFreeChart createDistrubutionChart(CategoryDataset dataset, String yAxis) {
        JFreeChart chart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.getLegend().setPosition(RectangleEdge.RIGHT);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        CategoryAxis domainAxis = new CategoryAxis(null);
        plot.setDomainAxis(domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
        domainAxis.setLowerMargin(0.1);
        domainAxis.setUpperMargin(0.1);
        domainAxis.setTickLabelsVisible(true);
        domainAxis.setCategoryMargin(0.1);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerBound(0.0);
        StackedBarRenderer renderer = (StackedBarRenderer)plot.getRenderer();
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        renderer.setBaseItemLabelsVisible(true);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)new DecimalFormat("0")));
        plot.setRenderer((CategoryItemRenderer)renderer);
        return chart;
    }

    public static Map<FileType, Integer> convertLangDistMap(Map<FileType, MutableInt> locPerType) {
        HashMap<FileType, Integer> langDistMap = new HashMap<FileType, Integer>();
        for (Map.Entry<FileType, MutableInt> entry : locPerType.entrySet()) {
            langDistMap.put(entry.getKey(), entry.getValue().toInteger());
        }
        return langDistMap;
    }
}

