/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nsiq;

import com.uwyn.jhighlight.renderer.CppXhtmlRenderer;
import com.uwyn.jhighlight.renderer.GroovyXhtmlRenderer;
import com.uwyn.jhighlight.renderer.JavaXhtmlRenderer;
import com.uwyn.jhighlight.renderer.Renderer;
import com.uwyn.jhighlight.renderer.XmlXhtmlRenderer;
import hudson.FilePath;
import hudson.plugins.nsiq.Encoding;
import hudson.plugins.nsiq.FileExtension;
import hudson.plugins.nsiq.SourcePainter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class SourcePainter {
    private Renderer getRenderer(FilePath filePath) {
        String filename = filePath.getRemote();
        FileExtension extension = FileExtension.getExtension((String)filename);
        switch (1.$SwitchMap$hudson$plugins$nsiq$FileExtension[extension.ordinal()]) {
            case 1: {
                return new GroovyXhtmlRenderer();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new CppXhtmlRenderer();
            }
            case 7: 
            case 8: 
            case 9: {
                return new XmlXhtmlRenderer();
            }
        }
        return new JavaXhtmlRenderer();
    }

    public String paint(FilePath filePath, Encoding encoding) throws IOException {
        InputStream inputStream = filePath.read();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Renderer renderer = this.getRenderer(filePath);
        renderer.highlight(filePath.getRemote(), inputStream, (OutputStream)outputStream, encoding.getEncodingKey(), true);
        StringBuffer sb = new StringBuffer();
        String[] splitted = outputStream.toString(encoding.getEncodingKey()).split("\n");
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        sb.append("<div style=\"overflow-x:scroll;\">").append("\n");
        sb.append("<table class=\"source\">").append("\n");
        sb.append("<colgroup>").append("\n");
        sb.append("<col width=\"40\"/>").append("\n");
        sb.append("<col width=\"\"/>").append("\n");
        sb.append("</colgroup>").append("\n");
        for (int line = 1; line < splitted.length && line <= 10000; ++line) {
            sb.append("<tr class=\"kwnone\">").append("\n");
            sb.append("<td class=\"line\">" + line + "</td>").append("\n");
            sb.append("<td class=\"code\">" + splitted[line] + "</td>").append("\n");
            sb.append("</tr>").append("\n");
        }
        sb.append("</table>").append("\n");
        sb.append("</div>");
        return sb.toString();
    }
}

