/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nsiq;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.TaskListener;
import hudson.plugins.nsiq.NSiqUtil;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSiqBuilder
extends Builder {
    private final String srcDir;
    private final String fileFilter;
    private static final String DELIMITER = ",";
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public NSiqBuilder(String srcDir, String fileFilter) {
        this.srcDir = srcDir;
        this.fileFilter = fileFilter;
    }

    public String getSrcDir() {
        return this.srcDir;
    }

    public String getFileFilter() {
        return this.fileFilter;
    }

    private String[] getSourceDirs() {
        if (this.srcDir.contains(DELIMITER)) {
            LinkedList<String> result = new LinkedList<String>();
            List<String> splitted = Arrays.asList(this.srcDir.split(DELIMITER));
            for (String dir : splitted) {
                String trim = dir.trim();
                if (!StringUtils.isNotEmpty((String)trim)) continue;
                result.add(trim);
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[]{this.srcDir.trim()};
    }

    public BuildStepDescriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (StringUtils.isEmpty((String)DESCRIPTOR.getNsiqPath())) {
            listener.getLogger().println("[N'SIQ Collector] N'SIQ Collector path is not configured...");
            return true;
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        FilePath moduleRoot = build.getModuleRoots().length == 1 ? build.getModuleRoot() : build.getModuleRoot().getParent();
        args.add(DESCRIPTOR.getNsiqPath());
        args.add("--csv");
        args.add("-i");
        args.add(new String[]{"-l", NSiqUtil.getLocFile(moduleRoot).getRemote()});
        args.add(new String[]{"-c", NSiqUtil.getComplexityFile(moduleRoot).getRemote()});
        if (this.fileFilter != null && StringUtils.isNotEmpty((String)this.fileFilter.trim())) {
            FilePath filterFilePath = new FilePath(moduleRoot, this.fileFilter.trim());
            if (filterFilePath.exists()) {
                args.add(new String[]{"-f", filterFilePath.getRemote()});
            } else {
                listener.getLogger().println("File filter location " + filterFilePath.getRemote() + " is not available. use default filefilter.txt");
            }
        }
        for (String srcDir : this.getSourceDirs()) {
            args.add(new FilePath(moduleRoot, srcDir.startsWith(File.separator) ? srcDir.substring(File.separator.length()) : srcDir).getRemote());
        }
        Launcher.ProcStarter procStater = launcher.launch();
        procStater.cmds(args.toCommandArray());
        procStater.envs((Map)build.getEnvironment((TaskListener)listener));
        procStater.pwd(moduleRoot);
        procStater.stdout((OutputStream)listener.getLogger());
        procStater.stderr((OutputStream)listener.getLogger());
        int result = launcher.launch(procStater).join();
        return result == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String nsiqPath;

        public DescriptorImpl() {
            super(NSiqBuilder.class);
            this.load();
        }

        public String getNsiqPath() {
            return this.nsiqPath;
        }

        public void setNsiqPath(String nsiqPath) {
            this.nsiqPath = nsiqPath;
        }

        public String getDisplayName() {
            return "Execute N'SIQ Collector";
        }

        public FormValidation doCheckPath(StaplerRequest request, StaplerResponse response, @QueryParameter(value="nsiqPath") String nsiqPath) throws IOException, ServletException {
            return FormValidation.validateExecutable((String)nsiqPath);
        }

        public boolean configure(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            this.nsiqPath = req.getParameter("nsiq.nsiqPath");
            this.save();
            return super.configure(req, jsonObject);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.equals(jobType);
        }
    }
}

