/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nsiq;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.FreeStyleProject;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.nsiq.Encoding;
import hudson.plugins.nsiq.NSiqAware;
import hudson.plugins.nsiq.NSiqBuildAction;
import hudson.plugins.nsiq.NSiqProjectAction;
import hudson.plugins.nsiq.NSiqTarget;
import hudson.plugins.nsiq.NSiqUtil;
import hudson.plugins.nsiq.model.Complexity;
import hudson.plugins.nsiq.model.Loc;
import hudson.plugins.nsiq.model.NSiqResult;
import hudson.plugins.nsiq.model.NSiqSummary;
import hudson.plugins.nsiq.parser.ComplexityParser;
import hudson.plugins.nsiq.parser.LocParser;
import hudson.plugins.nsiq.parser.NSiqResultParser;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSiqPublisher
extends Recorder
implements NSiqAware {
    private final double lowRatio;
    private final double highRatio;
    private boolean locView = true;
    private boolean complexityView = true;
    private boolean overView;
    private boolean dailyView;
    private final Encoding encoding;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public NSiqPublisher(double lowRatio, double highRatio, boolean locView, boolean complexityView, boolean overView, boolean dailyView, Encoding encoding) {
        this.lowRatio = lowRatio;
        this.highRatio = highRatio;
        this.locView = locView;
        this.complexityView = complexityView;
        this.overView = overView;
        this.dailyView = dailyView;
        this.encoding = encoding;
    }

    public boolean isLocView() {
        return this.locView;
    }

    public boolean isComplexityView() {
        return this.complexityView;
    }

    public boolean isOverView() {
        return this.overView;
    }

    public boolean isDailyView() {
        return this.dailyView;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.FAILURE)) {
            return false;
        }
        FilePath moduleRoot = build.getModuleRoots().length == 1 ? build.getModuleRoot() : build.getModuleRoot().getParent();
        FilePath locFile = NSiqUtil.getLocFile(moduleRoot);
        FilePath complexityFile = NSiqUtil.getComplexityFile(moduleRoot);
        if (!locFile.exists() || !complexityFile.exists()) {
            return false;
        }
        LocParser locParser = new LocParser(locFile);
        List<Loc> locList = locParser.parse();
        ComplexityParser complexityParser = new ComplexityParser(complexityFile);
        List<Complexity> complexityList = complexityParser.parse();
        NSiqResultParser nsiqCollectorParser = new NSiqResultParser(locList, complexityList);
        List<NSiqResult> nsiqResult = nsiqCollectorParser.parse();
        NSiqSummary summary = nsiqCollectorParser.getSummary();
        NSiqTarget target = NSiqTarget.load(build, nsiqResult);
        target.setOwner(null);
        NSiqUtil.getDataFile(build).write((Object)target);
        target.setOwner(build);
        locFile.delete();
        complexityFile.delete();
        NSiqBuildAction action = NSiqBuildAction.load(build, summary, target, this.lowRatio, this.highRatio);
        build.getActions().add(action);
        return true;
    }

    public Action getProjectAction(Project project) {
        return new NSiqProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Encoding getEncoding() {
        return this.encoding == null ? Encoding.UTF_8 : this.encoding;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Publish N'SIQ Collector";
        }

        public String getLowRatio(NSiqPublisher instance) {
            if (instance == null) {
                return "10.0";
            }
            return NSiqUtil.getFormattedComplexity(instance.lowRatio);
        }

        public String getHighRatio(NSiqPublisher instance) {
            if (instance == null) {
                return "0.5";
            }
            return NSiqUtil.getFormattedComplexity(instance.highRatio);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.equals(jobType);
        }
    }
}

