/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nsiq.model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileType {
    JAVA("Java", "Java", new String[]{"java"}),
    CCPP("C/C++", "C/C++", new String[]{"cpp", "h", "c", "hxx", "cxx", "hpp"}),
    CSharp("C#", "C#", new String[]{"cs"}),
    ObjectiveC("ObjC", "ObjC", new String[]{"m"}),
    HTML("Html", "HTML", new String[]{"htm", "html"}),
    JSP_PHP("JSP/PHP", "JSP\nPHP", new String[]{"jsp", "php"}),
    JAVASCRIPT_ACTIONSCRIPT("JavaScript/ActionScript", "Java /\nAction\nScript", new String[]{"js", "as"}),
    SHELL("Shell", "Shell", null);

    private final String name;
    private final String[] extensions;
    private final String displayName;

    private FileType(String name, String displayName, String[] extensions) {
        this.name = name;
        this.displayName = displayName;
        this.extensions = extensions;
    }

    public String getFileType() {
        return this.toString();
    }

    public String getName() {
        return this.name;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public static FileType getFileType(String name) {
        for (FileType fileType : FileType.values()) {
            if (!fileType.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return fileType;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

