/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nsiq.model;

import hudson.plugins.nsiq.NSiqAware;
import hudson.plugins.nsiq.model.Complexity;
import hudson.plugins.nsiq.model.FileType;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSiqResult
implements Comparable<NSiqResult>,
NSiqAware {
    private FileType eType;
    private String type;
    private String dir = null;
    private String file = null;
    private int complexity;
    private List<Complexity> functions = null;
    private int totalLoc;
    private int codeLoc;

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public void setComplexity(int complexity) {
        this.complexity = complexity;
    }

    public List<Complexity> getFunctions() {
        return this.functions;
    }

    public void setFunctions(List<Complexity> functions) {
        this.functions = functions;
    }

    public int getTotalLoc() {
        return this.totalLoc;
    }

    public void setTotalLoc(int totalLoc) {
        this.totalLoc = totalLoc;
    }

    public int getCodeLoc() {
        return this.codeLoc;
    }

    public void setCodeLoc(int codeLoc) {
        this.codeLoc = codeLoc;
    }

    public boolean isOnlyLoc() {
        return this.functions == null || this.functions.isEmpty();
    }

    private int getCount(int metric) {
        if (this.isOnlyLoc()) {
            return 0;
        }
        int count = 0;
        for (Complexity complexity : this.functions) {
            if (complexity.getComplexity() < metric) continue;
            ++count;
        }
        return count;
    }

    public int getHighCount() {
        return this.getCount(30);
    }

    public int getLowCount() {
        return this.getCount(10);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    public int hashCode() {
        return this.dir.hashCode() * 31 + this.file.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof NSiqResult && this.compareTo((NSiqResult)object) == 0;
    }

    @Override
    public int compareTo(NSiqResult nsiqCollector) {
        if (nsiqCollector == null) {
            return -1;
        }
        if (!this.dir.equals(nsiqCollector.getDir())) {
            return this.dir.compareTo(nsiqCollector.getDir());
        }
        return this.file.compareTo(nsiqCollector.getFile());
    }

    public void seteType(FileType eType) {
        this.eType = eType;
    }

    public FileType geteType() {
        if (this.eType == null) {
            this.eType = FileType.getFileType(this.type);
        }
        return this.eType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        if (this.type == null && this.eType != null) {
            this.type = this.eType.getName();
        }
        return this.type;
    }
}

