/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nsiq.parser;

import hudson.plugins.nsiq.NSiqAware;
import hudson.plugins.nsiq.NSiqUtil;
import hudson.plugins.nsiq.model.Complexity;
import hudson.plugins.nsiq.model.FileType;
import hudson.plugins.nsiq.model.Loc;
import hudson.plugins.nsiq.model.NSiqResult;
import hudson.plugins.nsiq.model.NSiqSummary;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSiqResultParser
implements NSiqAware {
    private final List<Loc> locList;
    private final List<Complexity> complexityList;
    private final NSiqSummary summary = new NSiqSummary();
    private final List<NSiqResult> result = new LinkedList();

    public NSiqResultParser(List<Loc> locList, List<Complexity> complexityList) {
        this.locList = locList;
        this.complexityList = complexityList;
    }

    private String getDir(String filename, String target) {
        File file = new File(filename);
        String dir = file.getParent();
        return StringUtils.isEmpty((String)dir) ? "[" + target + "]" : dir;
    }

    private String getFile(String filename) {
        File file = new File(filename);
        return file.getName();
    }

    private int getIndex(String filename, String target) {
        String dir = this.getDir(filename, target);
        String file = this.getFile(filename);
        for (int i = 0; i < this.result.size(); ++i) {
            if (!dir.equals(((NSiqResult)this.result.get(i)).getDir()) || !file.equals(((NSiqResult)this.result.get(i)).getFile())) continue;
            return i;
        }
        return -1;
    }

    private NSiqResult getNSiqResult(Loc loc) {
        NSiqResult nsiq = new NSiqResult();
        nsiq.seteType(loc.getType());
        nsiq.setDir(this.getDir(loc.getFile(), loc.getTarget()));
        nsiq.setFile(this.getFile(loc.getFile()));
        nsiq.setTotalLoc(loc.getTotalLoc());
        nsiq.setCodeLoc(loc.getCodeLoc());
        return nsiq;
    }

    public List<NSiqResult> parse() {
        int total = 0;
        int high = 0;
        int low = 0;
        int comp = 0;
        int totalLoc = 0;
        int codeLoc = 0;
        HashMap<FileType, MutableInt> locPerType = new HashMap<FileType, MutableInt>();
        for (Loc loc : this.locList) {
            totalLoc += loc.getTotalLoc();
            codeLoc += loc.getCodeLoc();
            this.result.add(this.getNSiqResult(loc));
            MutableInt eachLocPerType = (MutableInt)locPerType.get(loc.getType());
            if (eachLocPerType == null) {
                eachLocPerType = new MutableInt();
                locPerType.put(loc.getType(), eachLocPerType);
            }
            eachLocPerType.add(loc.getCodeLoc());
        }
        for (Complexity complexity : this.complexityList) {
            List<Complexity> functions;
            int index = this.getIndex(complexity.getFile(), complexity.getTarget());
            if (index < 0) continue;
            NSiqResult nsiq = (NSiqResult)this.result.get(index);
            List list = functions = nsiq.getFunctions() == null ? new LinkedList() : nsiq.getFunctions();
            if (nsiq.getComplexity() < complexity.getComplexity()) {
                nsiq.setComplexity(complexity.getComplexity());
            }
            ++total;
            if (complexity.getComplexity() >= 30) {
                ++high;
            }
            if (complexity.getComplexity() >= 10) {
                functions.add(complexity);
                nsiq.setFunctions(functions);
                ++low;
            }
            comp += complexity.getComplexity();
        }
        this.summary.setTotal(total);
        this.summary.setHigh(high);
        this.summary.setLow(low);
        this.summary.setComplexity(comp);
        this.summary.setTotalLoc(totalLoc);
        this.summary.setCodeLoc(codeLoc);
        this.summary.setLocPerType(NSiqUtil.convertLangDistMap(locPerType));
        Collections.sort(this.result);
        return this.result;
    }

    public NSiqSummary getSummary() {
        return this.summary;
    }
}

