/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nsiq;

import hudson.model.Actionable;
import hudson.model.Build;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.ProminentProjectAction;
import hudson.plugins.nsiq.NSiqBuildAction;
import hudson.plugins.nsiq.NSiqPublisher;
import hudson.util.Graph;
import java.io.IOException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSiqProjectAction
extends Actionable
implements ProminentProjectAction {
    private final Project<?, ?> project;

    public NSiqProjectAction(Project<?, ?> project) {
        this.project = project;
    }

    public Project<?, ?> getProject() {
        return this.project;
    }

    public Project<?, ?> getOwner() {
        return this.project;
    }

    public String getDisplayName() {
        return "N'SIQ Collector";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "nsiq";
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public boolean isLocView() {
        return this.getPublisher().isLocView();
    }

    public boolean isComplexityView() {
        return this.getPublisher().isComplexityView();
    }

    private NSiqPublisher getPublisher() {
        return (NSiqPublisher)this.project.getPublisher((Descriptor)NSiqPublisher.DESCRIPTOR);
    }

    public NSiqBuildAction getLastResult() {
        for (Build build = (Build)this.project.getLastSuccessfulBuild(); build != null; build = (Build)build.getPreviousNotFailedBuild()) {
            NSiqBuildAction action = (NSiqBuildAction)build.getAction(NSiqBuildAction.class);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public Graph getLocDistGraph() {
        if (this.getLastResult() != null) {
            return this.getLastResult().getLocDistGraph();
        }
        return null;
    }

    public Graph getLocGraph() {
        if (this.getLastResult() != null) {
            return this.getLastResult().getLocGraph();
        }
        return null;
    }

    public Graph getComplexityGraph() {
        if (this.getLastResult() != null) {
            return this.getLastResult().getComplexityGraph();
        }
        return null;
    }

    public Integer getLastResultBuild() {
        for (Build build = (Build)this.project.getLastSuccessfulBuild(); build != null; build = (Build)build.getPreviousNotFailedBuild()) {
            NSiqBuildAction action = (NSiqBuildAction)build.getAction(NSiqBuildAction.class);
            if (action == null) continue;
            return build.getNumber();
        }
        return null;
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Integer buildNumber = this.getLastResultBuild();
        if (buildNumber == null) {
            rsp.sendRedirect2("nodata");
        } else {
            rsp.sendRedirect2("../" + buildNumber + "/" + "nsiq");
        }
    }
}

