/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nunit;

import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.agent.AbortException;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.plugins.nunit.NUnitArchiver;
import hudson.plugins.nunit.NUnitPublisher;
import hudson.plugins.nunit.NUnitReportTransformer;
import hudson.plugins.nunit.TestReportArchiver;
import hudson.plugins.nunit.TestReportTransformer;
import hudson.tasks.Publisher;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.test.TestResultProjectAction;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NUnitPublisher
extends Publisher
implements TestReportArchiver {
    private static final transient String PLUGIN_NUNIT = "/plugin/nunit/";
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();
    private String testResultsPattern;
    private boolean debug = false;
    private boolean keepJUnitReports = false;
    private boolean skipJUnitArchiver = false;
    private AbstractBuild<?, ?> build;
    private Launcher launcher;
    private BuildListener listener;

    public NUnitPublisher(String testResultsPattern, boolean debug, boolean keepJUnitReports, boolean skipJUnitArchiver) {
        this.testResultsPattern = testResultsPattern;
        this.debug = debug;
        if (this.debug) {
            this.keepJUnitReports = keepJUnitReports;
            this.skipJUnitArchiver = skipJUnitArchiver;
        }
    }

    public String getTestResultsPattern() {
        return this.testResultsPattern;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean getKeepJunitReports() {
        return this.keepJUnitReports;
    }

    public boolean getSkipJunitArchiver() {
        return this.skipJUnitArchiver;
    }

    public Action getProjectAction(Project project) {
        return new TestResultProjectAction((AbstractProject)project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.build = build;
        this.launcher = launcher;
        this.listener = listener;
        if (this.debug) {
            listener.getLogger().println("NUnit publisher running in debug mode.");
        }
        Boolean result = Boolean.FALSE;
        try {
            NUnitArchiver transformer = new NUnitArchiver(listener, this.testResultsPattern, (TestReportArchiver)this, (TestReportTransformer)new NUnitReportTransformer(), this.keepJUnitReports, this.skipJUnitArchiver);
            result = (Boolean)build.getProject().getWorkspace().act((FilePath.FileCallable)transformer);
        }
        catch (TransformerException te) {
            throw new AbortException("Could not read the XSL XML file. Please report this issue to the plugin author", (Exception)te);
        }
        catch (ParserConfigurationException pce) {
            throw new AbortException("Could not initalize the XML parser. Please report this issue to the plugin author", (Exception)pce);
        }
        return result;
    }

    public boolean archive() throws InterruptedException, IOException {
        return new JUnitResultArchiver("temporary-junit-reports/TEST-*.xml").perform(this.build, this.launcher, this.listener);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

