/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nunit;

import hudson.AbortException;
import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.plugins.nunit.TestReportArchiver;
import hudson.plugins.nunit.TestReportTransformer;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NUnitArchiver
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = 1L;
    public static final String JUNIT_REPORTS_PATH = "temporary-junit-reports";
    private final transient String testResultsPattern;
    private transient boolean keepJUnitReports = false;
    private transient boolean skipJUnitArchiver = false;
    private final transient BuildListener listener;
    private transient TestReportTransformer unitReportTransformer;
    private transient TestReportArchiver unitResultArchiver;

    public NUnitArchiver(BuildListener listener, String testResults, TestReportArchiver unitResultArchiver, TestReportTransformer transformer, boolean keepJUnitReports, boolean skipJUnitArchiver) throws TransformerException, ParserConfigurationException {
        this.unitResultArchiver = unitResultArchiver;
        this.listener = listener;
        this.testResultsPattern = testResults;
        this.unitReportTransformer = transformer;
        this.keepJUnitReports = keepJUnitReports;
        this.skipJUnitArchiver = skipJUnitArchiver;
    }

    public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
        Boolean retValue = Boolean.FALSE;
        this.listener.getLogger().println("Transforming NUnit tests results");
        String[] nunitFiles = this.findNUnitReports(ws);
        File junitOutputPath = new File(ws, JUNIT_REPORTS_PATH);
        junitOutputPath.mkdirs();
        for (String nunitFileName : nunitFiles) {
            FileInputStream fileStream = new FileInputStream(new File(ws, nunitFileName));
            try {
                this.unitReportTransformer.transform(fileStream, junitOutputPath);
            }
            catch (TransformerException te) {
                throw new IOException2("Could not transform the NUnit report. Please report this issue to the plugin author", (Throwable)te);
            }
            catch (SAXException se) {
                throw new IOException2("Could not transform the NUnit report. Please report this issue to the plugin author", (Throwable)se);
            }
            finally {
                fileStream.close();
            }
        }
        if (this.skipJUnitArchiver) {
            this.listener.getLogger().println("Skipping feeding JUnit reports to JUnitArchiver");
        } else {
            retValue = this.performJUnitArchiver();
        }
        if (this.keepJUnitReports) {
            this.listener.getLogger().println("Skipping deletion of temporary JUnit reports.");
        } else {
            for (File file : junitOutputPath.listFiles()) {
                file.delete();
            }
            junitOutputPath.delete();
        }
        return retValue;
    }

    private String[] findNUnitReports(File parentPath) throws AbortException {
        FileSet fs = new FileSet();
        Project p = new Project();
        fs.setProject(p);
        fs.setDir(parentPath);
        fs.setIncludes(this.testResultsPattern);
        DirectoryScanner ds = fs.getDirectoryScanner(p);
        String[] nunitFiles = ds.getIncludedFiles();
        if (nunitFiles.length == 0) {
            this.listener.fatalError("No NUnit test report files were found. Configuration error?");
            throw new AbortException();
        }
        return nunitFiles;
    }

    private Boolean performJUnitArchiver() throws IOException {
        Boolean retValue = Boolean.TRUE;
        try {
            if (!this.unitResultArchiver.archive()) {
                retValue = Boolean.FALSE;
            }
        }
        catch (InterruptedException ie) {
            throw new IOException2((Throwable)ie);
        }
        return retValue;
    }
}

