/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nunit;

import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.agent.AbortException;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.plugins.nunit.NUnitArchiver;
import hudson.plugins.nunit.NUnitReportTransformer;
import hudson.tasks.Publisher;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.test.TestResultProjectAction;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NUnitPublisher
extends Publisher {
    private static final transient String PLUGIN_NUNIT = "/plugin/nunit/";
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();
    private String testResultsPattern;
    private boolean debug = false;
    private boolean keepJUnitReports = false;
    private boolean skipJUnitArchiver = false;

    public NUnitPublisher(String testResultsPattern, boolean debug, boolean keepJUnitReports, boolean skipJUnitArchiver) {
        this.testResultsPattern = testResultsPattern;
        this.debug = debug;
        if (this.debug) {
            this.keepJUnitReports = keepJUnitReports;
            this.skipJUnitArchiver = skipJUnitArchiver;
        }
    }

    public String getTestResultsPattern() {
        return this.testResultsPattern;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean getKeepJunitReports() {
        return this.keepJUnitReports;
    }

    public boolean getSkipJunitArchiver() {
        return this.skipJUnitArchiver;
    }

    public Action getProjectAction(Project project) {
        return new TestResultProjectAction((AbstractProject)project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.debug) {
            listener.getLogger().println("NUnit publisher running in debug mode.");
        }
        Boolean result = Boolean.TRUE;
        try {
            NUnitArchiver transformer = new NUnitArchiver(listener, this.testResultsPattern, new NUnitReportTransformer());
            result = (Boolean)build.getProject().getWorkspace().act((FilePath.FileCallable)transformer);
            if (result.booleanValue()) {
                if (this.skipJUnitArchiver) {
                    listener.getLogger().println("Skipping feeding JUnit reports to JUnitArchiver");
                } else {
                    result = new JUnitResultArchiver("temporary-junit-reports/TEST-*.xml").perform(build, launcher, listener);
                }
                if (this.keepJUnitReports) {
                    listener.getLogger().println("Skipping deletion of temporary JUnit reports.");
                } else {
                    build.getProject().getWorkspace().child("temporary-junit-reports").deleteRecursive();
                }
            }
        }
        catch (TransformerException te) {
            throw new AbortException("Could not read the XSL XML file. Please report this issue to the plugin author", (Exception)te);
        }
        return result;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<Publisher> {
        protected DescriptorImpl() {
            super(NUnitPublisher.class);
        }

        public String getDisplayName() {
            return "Publish NUnit test result report";
        }

        public String getHelpFile() {
            return "/plugin/nunit/help.html";
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new NUnitPublisher(req.getParameter("nunit_reports.pattern"), req.hasParameter("nunit_reports.debug") ? Boolean.parseBoolean(req.getParameter("nunit_reports.debug")) : false, req.hasParameter("nunit_reports.keepjunitreports") ? Boolean.parseBoolean(req.getParameter("nunit_reports.keepjunitreports")) : false, req.hasParameter("nunit_reports.skipjunitarchiver") ? Boolean.parseBoolean(req.getParameter("nunit_reports.skipjunitarchiver")) : false);
        }
    }
}

