/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nunit;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.nunit.NUnitArchiver;
import hudson.plugins.nunit.NUnitReportTransformer;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Publisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NUnitPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient String PLUGIN_NUNIT = "/plugin/nunit/";
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();
    private String testResultsPattern;
    private boolean debug = false;
    private boolean keepJUnitReports = false;
    private boolean skipJUnitArchiver = false;

    public NUnitPublisher(String testResultsPattern, boolean debug, boolean keepJUnitReports, boolean skipJUnitArchiver) {
        this.testResultsPattern = testResultsPattern;
        this.debug = debug;
        if (this.debug) {
            this.keepJUnitReports = keepJUnitReports;
            this.skipJUnitArchiver = skipJUnitArchiver;
        }
    }

    public String getTestResultsPattern() {
        return this.testResultsPattern;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean getKeepJunitReports() {
        return this.keepJUnitReports;
    }

    public boolean getSkipJunitArchiver() {
        return this.skipJUnitArchiver;
    }

    public Action getProjectAction(Project project) {
        TestResultProjectAction action = (TestResultProjectAction)project.getAction(TestResultProjectAction.class);
        if (action == null) {
            return new TestResultProjectAction((AbstractProject)project);
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.debug) {
            listener.getLogger().println("NUnit publisher running in debug mode.");
        }
        boolean result = true;
        try {
            listener.getLogger().println("Recording NUnit tests results");
            NUnitArchiver transformer = new NUnitArchiver(listener, this.testResultsPattern, new NUnitReportTransformer());
            result = (Boolean)build.getProject().getWorkspace().act((FilePath.FileCallable)transformer);
            if (result) {
                if (this.skipJUnitArchiver) {
                    listener.getLogger().println("Skipping feeding JUnit reports to JUnitArchiver");
                } else {
                    result = this.recordTestResult("temporary-junit-reports/TEST-*.xml", build, listener);
                }
                if (this.keepJUnitReports) {
                    listener.getLogger().println("Skipping deletion of temporary JUnit reports.");
                } else {
                    build.getProject().getWorkspace().child("temporary-junit-reports").deleteRecursive();
                }
            }
        }
        catch (TransformerException te) {
            throw new AbortException("Could not read the XSL XML file. Please report this issue to the plugin author");
        }
        return result;
    }

    private boolean recordTestResult(String junitFilePattern, AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException, IOException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            TestResult existingTestResults = null;
            if (existingAction != null) {
                existingTestResults = existingAction.getResult();
            }
            TestResult result = this.getTestResult(junitFilePattern, build, existingTestResults, buildTime);
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                throw new AbortException("None of the test reports contained any result");
            }
        }
        catch (AbortException e) {
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
        if (action.getResult().getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private TestResult getTestResult(final String junitFilePattern, AbstractBuild<?, ?> build, final TestResult existingTestResults, final long buildTime) throws IOException, InterruptedException {
        TestResult result = (TestResult)build.getProject().getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<TestResult>(){

            public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
                FileSet fs = Util.createFileSet((File)ws, (String)junitFilePattern);
                DirectoryScanner ds = fs.getDirectoryScanner();
                String[] files = ds.getIncludedFiles();
                if (files.length == 0) {
                    throw new AbortException("No test report files were found. Configuration error?");
                }
                if (existingTestResults == null) {
                    return new TestResult(buildTime, ds);
                }
                existingTestResults.parse(buildTime, ds);
                return existingTestResults;
            }
        });
        return result;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<Publisher> {
        protected DescriptorImpl() {
            super(NUnitPublisher.class);
        }

        public String getDisplayName() {
            return "Publish NUnit test result report";
        }

        public String getHelpFile() {
            return "/plugin/nunit/help.html";
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new NUnitPublisher(req.getParameter("nunit_reports.pattern"), req.getParameter("nunit_reports.debug") != null, req.getParameter("nunit_reports.keepjunitreports") != null, req.getParameter("nunit_reports.skipjunitarchiver") != null);
        }
    }
}

