/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.origo;

import ch.ethz.origo.OrigoApiClient;
import ch.ethz.origo.OrigoIssuePublisher;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrigoIssuePublisher
extends Notifier {
    private static final Logger LOGGER = Logger.getLogger(OrigoIssuePublisher.class.getName());
    static final String APPLICATION_KEY = "KEYFORTHEORIGOHUDSONISSUESPLUGIN";
    private String apiUrl;
    private String projectName;
    private String userKey;
    private String issueSubject;
    private String issueTag;
    private boolean issuePrivate;
    private OrigoApiClient client;

    OrigoIssuePublisher(String apiUrl, String projectName, String userKey, String issueSubject, String issueTag, boolean issuePrivate, OrigoApiClient client) {
        this.apiUrl = apiUrl;
        this.projectName = projectName;
        this.userKey = userKey;
        this.issueSubject = issueSubject;
        this.issueTag = issueTag;
        this.issuePrivate = issuePrivate;
        this.client = client;
    }

    @DataBoundConstructor
    public OrigoIssuePublisher(String apiUrl, String projectName, String userKey, String issueSubject, String issueTag, boolean issuePrivate) {
        this.apiUrl = apiUrl;
        this.projectName = projectName;
        this.userKey = userKey;
        this.issueSubject = issueSubject;
        this.issueTag = issueTag;
        this.issuePrivate = issuePrivate;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public String getIssueSubject() {
        return this.issueSubject;
    }

    public String getIssueTag() {
        return this.issueTag;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public boolean isIssuePrivate() {
        return this.issuePrivate;
    }

    private OrigoApiClient createClient() throws MalformedURLException {
        if (this.client == null) {
            return new OrigoApiClient(new URL(this.apiUrl));
        }
        return this.client;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        try {
            boolean isNewFailure = this.isNewFailure(build);
            boolean isRecovery = this.isRecovery(build);
            if (isNewFailure || isRecovery) {
                OrigoApiClient client = this.createClient();
                String session = client.login(this.userKey, APPLICATION_KEY);
                LOGGER.fine("Got session" + session);
                Integer projectId = client.retrieveProjectId(session, this.projectName);
                if (isNewFailure) {
                    this.openNewIssue(build, client, session, projectId);
                } else if (isRecovery) {
                    this.closeExistingIssue(build, client, session, projectId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to update origo issue.", e);
        }
        return true;
    }

    private void closeExistingIssue(AbstractBuild<?, ?> build, OrigoApiClient client, String session, Integer projectId) throws XmlRpcException {
        HashMap<String, String> searchArgs = new HashMap<String, String>();
        searchArgs.put("status", "open");
        searchArgs.put("tags", this.issueTag);
        Object[] issues = client.searchIssue(session, projectId, searchArgs);
        if (issues != null && issues.length == 1) {
            Map issue = (Map)issues[0];
            Integer issueId = (Integer)issue.get("issue_id");
            LOGGER.fine("Found issue with id " + issueId);
            String issueDescription = "Build fixed see: " + this.createLinkUrl(build);
            client.extendedCommentIssue(session, projectId, issueId, issueDescription, "status::closed," + this.issueTag);
        } else {
            LOGGER.warning("Did not find exactly one match.");
        }
    }

    private String createLinkUrl(AbstractBuild<?, ?> build) {
        return this.getDescriptor().getHudsonUrl() + build.getUrl();
    }

    private boolean isNewFailure(AbstractBuild<?, ?> build) {
        Result previousResult = build.getPreviousBuild() != null ? ((AbstractBuild)build.getPreviousBuild()).getResult() : Result.SUCCESS;
        Result currentResult = build.getResult();
        return previousResult == Result.SUCCESS && (currentResult == Result.FAILURE || build.getResult() == Result.UNSTABLE);
    }

    private boolean isRecovery(AbstractBuild<?, ?> build) {
        Result previousResult = build.getPreviousBuild() != null ? ((AbstractBuild)build.getPreviousBuild()).getResult() : Result.SUCCESS;
        Result currentResult = build.getResult();
        return currentResult == Result.SUCCESS && (previousResult == Result.FAILURE || ((AbstractBuild)build.getPreviousBuild()).getResult() == Result.UNSTABLE);
    }

    private void openNewIssue(AbstractBuild<?, ?> build, OrigoApiClient client, String session, Integer projectId) throws XmlRpcException {
        String issueDescription = "Build failed see: " + this.createLinkUrl(build);
        System.out.println(issueDescription);
        client.addIssue(session, projectId, this.issueSubject, issueDescription, "status::open," + this.issueTag, Boolean.valueOf(this.issuePrivate));
    }
}

