/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.origo;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrigoApiClient {
    private static final Logger LOGGER = Logger.getLogger(OrigoApiClient.class.getName());
    private final XmlRpcClient client = new XmlRpcClient();

    public OrigoApiClient(URL apiUrl) {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(apiUrl);
        this.client.setConfig((XmlRpcClientConfig)config);
    }

    protected synchronized Object call(String method, Object ... params) throws XmlRpcException {
        LOGGER.finest("Executing call " + method + " " + Arrays.toString(params));
        return this.client.execute(method, params);
    }

    public String login(String userKey, String applicationKey) throws XmlRpcException {
        return (String)this.call("user.login_key", userKey, applicationKey);
    }

    public Integer retrieveProjectId(String session, String projectName) throws XmlRpcException {
        return (Integer)this.call("project.retrieve_id", session, projectName);
    }

    public Object[] searchIssue(String session, Integer projectId, HashMap<String, String> searchArgs) throws XmlRpcException {
        return (Object[])this.call("issue.search", session, projectId, searchArgs);
    }

    public void extendedCommentIssue(String session, Integer projectId, Integer bugId, String description, String tags) throws XmlRpcException {
        this.call("issue.comment_extended_2", session, projectId, bugId, description, tags, 0, 0);
    }

    public void addIssue(String session, Integer projectId, String issueSubject, String issueDescription, String issueTag, Boolean issuePrivate) throws XmlRpcException {
        this.call("issue.add_2", session, projectId, issueSubject, issueDescription, issueTag, issuePrivate, 0, 0);
    }
}

