/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Items;
import hudson.model.ParameterizedProjectTask;
import hudson.model.Queue;
import hudson.model.StringParameterValue;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedPropertiesBuildTriggerConfig
extends BuildTriggerConfig {
    private final String projectsValue;
    private final String properties;
    private final ResultCondition condition;
    public static Descriptor<BuildTriggerConfig> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public PredefinedPropertiesBuildTriggerConfig(String projectsValue, String properties, ResultCondition condition) {
        this.projectsValue = projectsValue;
        this.properties = properties;
        this.condition = condition;
    }

    @Override
    public void trigger(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.condition.isMet(build.getResult())) {
            Properties p = new Properties();
            p.load(new StringReader(this.properties));
            for (AbstractProject project : this.getProjects()) {
                ArrayList<StringParameterValue> values = new ArrayList<StringParameterValue>();
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    values.add(new StringParameterValue(entry.getKey().toString(), entry.getValue().toString()));
                }
                Hudson.getInstance().getQueue().add((Queue.Task)new ParameterizedProjectTask(project, values), 0);
            }
        }
    }

    public List<AbstractProject> getProjects() {
        return Items.fromNameList((String)this.projectsValue, AbstractProject.class);
    }

    public String getProperties() {
        return this.properties;
    }

    public ResultCondition getCondition() {
        return this.condition;
    }

    public String getProjectsValue() {
        return this.projectsValue;
    }

    public Descriptor<BuildTriggerConfig> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<BuildTriggerConfig> {
        public DescriptorImpl() {
            super(PredefinedPropertiesBuildTriggerConfig.class);
        }

        public String getDisplayName() {
            return "Use predefined properties";
        }

        public ResultCondition[] getPossibleResultConditions() {
            return ResultCondition.values();
        }
    }
}

