/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.model.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResultCondition {
    SUCCESS("Stable"){

        boolean isMet(Result result) {
            return result == Result.SUCCESS;
        }
    }
    ,
    UNSTABLE_OR_BETTER("Stable or unstable but not failed"){

        boolean isMet(Result result) {
            return result.isBetterOrEqualTo(Result.UNSTABLE);
        }
    }
    ,
    FAILED("Failed"){

        boolean isMet(Result result) {
            return result == Result.FAILURE;
        }
    };

    private final String displayName;

    private ResultCondition(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    abstract boolean isMet(Result var1);
}

