/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.TaskListener;
import hudson.tasks.BatchFile;
import hudson.tasks.Shell;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildTriggerConfig
implements Describable<BuildTriggerConfig> {
    protected String projectsValue;
    protected String batchCondition;

    public abstract void trigger(AbstractBuild<?, ?> var1, Launcher var2, BuildListener var3) throws IOException, InterruptedException;

    protected static String resolveParametersInString(AbstractBuild<?, ?> build, BuildListener listener, String input) {
        try {
            return build.getEnvironment((TaskListener)listener).expand(input);
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to resolve parameters in string \"" + input + "\" due to following error:\n" + e.getMessage());
            return input;
        }
    }

    protected boolean checkBatchCondition(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.batchCondition == null || this.batchCondition == "") {
            return true;
        }
        listener.getLogger().println("Checking batch condition for projects \"" + this.projectsValue + "\".");
        try {
            boolean result;
            Object batchRunner = launcher.isUnix() ? new Shell(this.batchCondition) : new BatchFile(this.batchCondition);
            boolean bl = result = batchRunner.perform(build, launcher, listener);
            if (!result) {
                listener.getLogger().println("Batch condition for projects \"" + this.projectsValue + "\" isn't met. Projects are not triggered.");
            } else {
                listener.getLogger().println("Batch condition for projects \"" + this.projectsValue + "\" is met.");
            }
            return result;
        }
        catch (InterruptedException e) {
            listener.getLogger().println("Failed to check batch condition \"" + this.batchCondition + "\"");
            return false;
        }
    }

    protected static void addDefaultParameters(AbstractProject project, List<ParameterValue> parametersValues, BuildListener listener) {
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (property != null) {
            for (ParameterDefinition parameterDefinition : property.getParameterDefinitions()) {
                parametersValues.add(parameterDefinition.getDefaultParameterValue());
            }
        }
    }

    public String getBatchCondition() {
        return this.batchCondition;
    }

    public Descriptor<BuildTriggerConfig> getDescriptor() {
        return Hudson.getInstance().getDescriptor(this.getClass());
    }
}

