/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.tasks.BatchFile;
import hudson.tasks.Shell;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class BuildTriggerConfig
implements Describable<BuildTriggerConfig> {
    protected String projectsValue;
    protected String batchCondition;

    public abstract void trigger(AbstractBuild<?, ?> var1, Launcher var2, BuildListener var3) throws IOException, InterruptedException;

    protected static String resolveParametersInString(AbstractBuild<?, ?> build, BuildListener listener, String input) {
        try {
            return build.getEnvironment((TaskListener)listener).expand(input);
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to resolve parameters in string \"" + input + "\" due to following error:\n" + e.getMessage());
            return input;
        }
    }

    protected boolean checkBatchCondition(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.batchCondition == null || this.batchCondition == "") {
            return true;
        }
        listener.getLogger().println("Checking batch condition for projects \"" + this.projectsValue + "\".");
        try {
            boolean result;
            Object batchRunner = launcher.isUnix() ? new Shell(this.batchCondition) : new BatchFile(this.batchCondition);
            boolean bl = result = batchRunner.perform(build, launcher, listener);
            if (!result) {
                listener.getLogger().println("Batch condition for projects \"" + this.projectsValue + "\" isn't met. Projects are not triggered.");
            } else {
                listener.getLogger().println("Batch condition for projects \"" + this.projectsValue + "\" is met.");
            }
            return result;
        }
        catch (InterruptedException e) {
            listener.getLogger().println("Failed to check batch condition \"" + this.batchCondition + "\"");
            return false;
        }
    }

    public List<ParameterValue> createParametersList(AbstractBuild<?, ?> build, AbstractProject project, boolean includeCurrentParameters, Properties specifiedParameters, BuildListener listener) {
        ParametersAction action;
        Hashtable<String, ParameterValue> parameters = new Hashtable<String, ParameterValue>();
        ParametersDefinitionProperty parametersProperty = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (parametersProperty != null) {
            for (ParameterDefinition parameterDefinition : parametersProperty.getParameterDefinitions()) {
                ParameterValue parameter2 = parameterDefinition.getDefaultParameterValue();
                parameters.put(parameter2.getName(), parameter2);
            }
        }
        if (includeCurrentParameters && (action = (ParametersAction)build.getAction(ParametersAction.class)) != null) {
            for (ParameterValue parameter : action.getParameters()) {
                parameters.put(parameter.getName(), parameter);
            }
        }
        for (Map.Entry entry : specifiedParameters.entrySet()) {
            ParameterValue parameter;
            parameter = new StringParameterValue(entry.getKey().toString(), BuildTriggerConfig.resolveParametersInString(build, (BuildListener)listener, (String)entry.getValue().toString()));
            parameters.put(parameter.getName(), parameter);
        }
        return new ArrayList<ParameterValue>(parameters.values());
    }

    public String getBatchCondition() {
        return this.batchCondition;
    }

    public Descriptor<BuildTriggerConfig> getDescriptor() {
        return Hudson.getInstance().getDescriptor(this.getClass());
    }
}

