/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.tasks.Publisher;
import hudson.util.DescriptorList;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTrigger
extends Publisher {
    private final List<BuildTriggerConfig> configs;
    public static final DescriptorList<BuildTriggerConfig> CONFIGS = new DescriptorList(BuildTriggerConfig.class);

    public BuildTrigger(List<BuildTriggerConfig> configs) {
        this.configs = configs;
    }

    public BuildTrigger(BuildTriggerConfig ... configs) {
        this(Arrays.asList(configs));
    }

    public List<BuildTriggerConfig> getConfigs() {
        return this.configs;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        for (BuildTriggerConfig config : this.configs) {
            config.trigger(build, launcher, listener);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<Publisher> {
        public Publisher newInstance(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            return new BuildTrigger(DescriptorImpl.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"configs", CONFIGS));
        }

        public String getHelpFile() {
            return "/plugin/parameterized-trigger/help/plugin.html";
        }

        public String getDisplayName() {
            return "Trigger parameterized build on other projects";
        }

        public DescriptorList<BuildTriggerConfig> getBuilderConfigDescriptors() {
            return CONFIGS;
        }
    }
}

