/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBuildTriggerConfig
extends BuildTriggerConfig {
    private final String propertiesFile;
    private final ResultCondition condition;
    private final boolean includeCurrentParameters;

    @DataBoundConstructor
    public FileBuildTriggerConfig(String projectsValue, String propertiesFile, ResultCondition condition, String batchCondition, boolean includeCurrentParameters) {
        this.projectsValue = projectsValue;
        this.propertiesFile = propertiesFile;
        this.condition = condition;
        this.batchCondition = batchCondition;
        this.includeCurrentParameters = includeCurrentParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trigger(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.condition.isMet(build.getResult()) && this.checkBatchCondition(build, launcher, listener)) {
            String resolvedPropertiesFile = FileBuildTriggerConfig.resolveParametersInString(build, listener, this.propertiesFile);
            FilePath f = build.getProject().getWorkspace().child(resolvedPropertiesFile);
            if (!f.exists()) {
                listener.getLogger().println("Could not trigger downstream project, as properties file" + resolvedPropertiesFile + " did not exist.");
                return;
            }
            Properties p = new Properties();
            InputStream is = f.read();
            try {
                p.load(is);
                is.close();
            }
            finally {
                is.close();
            }
            for (AbstractProject project : this.getProjects()) {
                List<ParameterValue> parameters = this.createParametersList(build, project, this.includeCurrentParameters, p, listener);
                project.scheduleBuild(0, (Cause)new Cause.UpstreamCause(build), new Action[]{new ParametersAction(parameters)});
            }
        }
    }

    public List<AbstractProject> getProjects() {
        return Items.fromNameList((String)this.projectsValue, AbstractProject.class);
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public ResultCondition getCondition() {
        return this.condition;
    }

    public String getProjectsValue() {
        return this.projectsValue;
    }

    public boolean isIncludeCurrentParameters() {
        return this.includeCurrentParameters;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<BuildTriggerConfig> {
        public String getDisplayName() {
            return "Get properties from property file";
        }

        public ResultCondition[] getPossibleResultConditions() {
            return ResultCondition.values();
        }
    }
}

