/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.filters.StringInputStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedPropertiesBuildTriggerConfig
extends BuildTriggerConfig {
    private final String properties;
    private final ResultCondition condition;
    private final boolean includeCurrentParameters;

    @DataBoundConstructor
    public PredefinedPropertiesBuildTriggerConfig(String projectsValue, String properties, ResultCondition condition, String batchCondition, boolean includeCurrentParameters) {
        this.projectsValue = projectsValue;
        this.properties = properties;
        this.condition = condition;
        this.batchCondition = batchCondition;
        this.includeCurrentParameters = includeCurrentParameters;
    }

    @Override
    public void trigger(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.condition.isMet(build.getResult()) && this.checkBatchCondition(build, launcher, listener)) {
            Properties p = new Properties();
            p.load((InputStream)new StringInputStream(this.properties));
            for (AbstractProject project : this.getProjects()) {
                List<ParameterValue> parameters = this.createParametersList(build, project, this.includeCurrentParameters, p, listener);
                project.scheduleBuild(0, (Cause)new Cause.UpstreamCause(build), new Action[]{new ParametersAction(parameters)});
            }
        }
    }

    public List<AbstractProject> getProjects() {
        return Items.fromNameList((String)this.projectsValue, AbstractProject.class);
    }

    public String getProperties() {
        return this.properties;
    }

    public ResultCondition getCondition() {
        return this.condition;
    }

    public boolean isIncludeCurrentParameters() {
        return this.includeCurrentParameters;
    }

    public String getProjectsValue() {
        return this.projectsValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<BuildTriggerConfig> {
        public String getDisplayName() {
            return "Use predefined properties";
        }

        public ResultCondition[] getPossibleResultConditions() {
            return ResultCondition.values();
        }
    }
}

