/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBuildParameters
extends AbstractBuildParameters {
    private final String propertiesFile;

    @DataBoundConstructor
    public FileBuildParameters(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public Action getAction(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        String resolvedPropertiesFile = env.expand(this.propertiesFile);
        FilePath f = build.getProject().getWorkspace().child(resolvedPropertiesFile);
        if (!f.exists()) {
            listener.getLogger().println("[parameterizedtrigger] Could not trigger downstream project, as properties file" + resolvedPropertiesFile + " did not exist.");
            return null;
        }
        String s = f.readToString();
        s = env.expand(s);
        Properties p = new Properties();
        p.load(new StringReader(s));
        ArrayList<StringParameterValue> values = new ArrayList<StringParameterValue>();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            values.add(new StringParameterValue(entry.getKey().toString(), entry.getValue().toString()));
        }
        return new ParametersAction(values);
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }
}

