/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Items;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTriggerConfig {
    private final List<AbstractBuildParameters> configs;
    private final String projects;
    private final ResultCondition condition;

    public BuildTriggerConfig(String projects, ResultCondition condition, List<AbstractBuildParameters> configs) {
        this.configs = configs;
        this.projects = projects;
        this.condition = condition;
    }

    public BuildTriggerConfig(String projects, ResultCondition condition, AbstractBuildParameters ... configs) {
        this(projects, condition, Arrays.asList(configs));
    }

    public List<AbstractBuildParameters> getConfigs() {
        return this.configs;
    }

    public String getProjects() {
        return this.projects;
    }

    public ResultCondition getCondition() {
        return this.condition;
    }

    public List<AbstractProject> getProjectList() {
        return Items.fromNameList((String)this.projects, AbstractProject.class);
    }

    private ParametersAction getDefaultParameters(AbstractProject<?, ?> project) {
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (property == null) {
            return null;
        }
        ArrayList<ParameterValue> parameters = new ArrayList<ParameterValue>();
        for (ParameterDefinition pd : property.getParameterDefinitions()) {
            parameters.add(pd.getDefaultParameterValue());
        }
        return new ParametersAction(parameters);
    }

    public void perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        try {
            if (this.condition.isMet(build.getResult())) {
                ArrayList<Action> actions = new ArrayList<Action>();
                for (AbstractBuildParameters config : this.configs) {
                    Action a = config.getAction(build, launcher, listener);
                    if (a == null) continue;
                    actions.add(a);
                }
                if (!actions.isEmpty()) {
                    for (AbstractProject project : this.getProjectList()) {
                        ArrayList<ParametersAction> list = new ArrayList<ParametersAction>(actions);
                        ParametersAction defaultParameters = this.getDefaultParameters(project);
                        if (defaultParameters != null) {
                            list.add(0, defaultParameters);
                        }
                        project.scheduleBuild(0, (Cause)new Cause.UpstreamCause(build), list.toArray(new Action[list.size()]));
                    }
                }
            }
        }
        catch (AbstractBuildParameters.DontTriggerException e) {
            return;
        }
    }

    public String toString() {
        return "BuildTriggerConfig [projects=" + this.projects + ", condition=" + this.condition + ", configs=" + this.configs + "]";
    }
}

