/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ParameterizedDependency;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.util.DescriptorList;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class BuildTrigger
extends Notifier
implements DependecyDeclarer {
    private final List<BuildTriggerConfig> configs;
    public static final DescriptorList<AbstractBuildParameters> CONFIGS = new DescriptorList(AbstractBuildParameters.class);

    public BuildTrigger(List<BuildTriggerConfig> configs) {
        this.configs = configs;
    }

    public BuildTrigger(BuildTriggerConfig ... configs) {
        this(Arrays.asList(configs));
    }

    public List<BuildTriggerConfig> getConfigs() {
        return this.configs;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (BuildTrigger.canDeclare()) {
            return true;
        }
        for (BuildTriggerConfig config : this.configs) {
            config.perform(build, launcher, listener);
        }
        return true;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        if (!BuildTrigger.canDeclare()) {
            return;
        }
        for (BuildTriggerConfig config : this.configs) {
            for (AbstractProject project : config.getProjectList()) {
                ParameterizedDependency.add((AbstractProject)owner, (AbstractProject)project, (BuildTriggerConfig)config, (DependencyGraph)graph);
            }
        }
    }

    private static boolean canDeclare() {
        return DependencyGraph.class.getClasses().length > 0;
    }
}

