/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ParameterizedDependency;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.DescriptorList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTrigger
extends Notifier
implements DependecyDeclarer {
    private final List<BuildTriggerConfig> configs;
    public static final DescriptorList<AbstractBuildParameters> CONFIGS = new DescriptorList(AbstractBuildParameters.class);

    public BuildTrigger(List<BuildTriggerConfig> configs) {
        this.configs = configs;
    }

    public BuildTrigger(BuildTriggerConfig ... configs) {
        this(Arrays.asList(configs));
    }

    public List<BuildTriggerConfig> getConfigs() {
        return this.configs;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (BuildTrigger.canDeclare()) {
            return true;
        }
        for (BuildTriggerConfig config : this.configs) {
            config.perform(build, launcher, listener);
        }
        return true;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        if (!BuildTrigger.canDeclare()) {
            return;
        }
        for (BuildTriggerConfig config : this.configs) {
            for (AbstractProject project : config.getProjectList()) {
                ParameterizedDependency.add(owner, project, config, graph);
            }
        }
    }

    private static boolean canDeclare() {
        return DependencyGraph.class.getClasses().length > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public Publisher newInstance(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            ArrayList<BuildTriggerConfig> result = new ArrayList<BuildTriggerConfig>();
            Object c = json.get("configs");
            if (c instanceof JSONObject) {
                JSONObject j = (JSONObject)c;
                result.add(this.bindBuildTrigger(req, j));
            }
            if (c instanceof JSONArray) {
                JSONArray a = (JSONArray)c;
                for (Object o : a) {
                    if (!(o instanceof JSONObject)) continue;
                    JSONObject j = (JSONObject)o;
                    result.add(this.bindBuildTrigger(req, j));
                }
            }
            return new BuildTrigger(result);
        }

        private BuildTriggerConfig bindBuildTrigger(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            return new BuildTriggerConfig(o.getString("projects"), ResultCondition.valueOf(o.getString("condition")), DescriptorImpl.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)o, (String)"configs", CONFIGS));
        }

        public String getHelpFile() {
            return "/plugin/parameterized-trigger/help/plugin.html";
        }

        public String getDisplayName() {
            return "Trigger parameterized build on other projects";
        }

        public DescriptorList<AbstractBuildParameters> getBuilderConfigDescriptors() {
            return CONFIGS;
        }

        public ResultCondition[] getPossibleResultConditions() {
            return ResultCondition.values();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

