/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.filters.StringInputStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedBuildParameters
extends AbstractBuildParameters {
    private final String properties;

    @DataBoundConstructor
    public PredefinedBuildParameters(String properties) {
        this.properties = properties;
    }

    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment(listener);
        Properties p = new Properties();
        p.load((InputStream)new StringInputStream(this.properties));
        ArrayList<StringParameterValue> values = new ArrayList<StringParameterValue>();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            values.add(new StringParameterValue(entry.getKey().toString(), env.expand(entry.getValue().toString())));
        }
        return new ParametersAction(values);
    }

    public String getProperties() {
        return this.properties;
    }
}

