/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.listeners.ItemListener;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import hudson.util.EnumConverter;
import java.io.IOException;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.Stapler;

public class Plugin
extends hudson.Plugin {
    public void start() throws Exception {
        Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), ResultCondition.class);
    }

    @Extension
    public static final class RenameListener
    extends ItemListener {
        public void onRenamed(Item item, String oldName, String newName) {
            for (Project p : Hudson.getInstance().getProjects()) {
                BuildTrigger t = (BuildTrigger)p.getPublishersList().get(BuildTrigger.class);
                if (t == null) continue;
                boolean changed = false;
                for (BuildTriggerConfig c : t.getConfigs()) {
                    changed |= c.onJobRenamed(oldName, newName);
                }
                if (!changed) continue;
                try {
                    p.save();
                }
                catch (IOException e) {
                    Logger.getLogger(RenameListener.class.getName()).log(Level.WARNING, "Failed to persist project setting during rename from " + oldName + " to " + newName, e);
                }
            }
        }

        public void onDeleted(Item item) {
            for (Project p : Hudson.getInstance().getProjects()) {
                String oldName = item.getName();
                BuildTrigger t = (BuildTrigger)p.getPublishersList().get(BuildTrigger.class);
                if (t == null) continue;
                boolean changed = false;
                ListIterator<BuildTriggerConfig> it = t.getConfigs().listIterator();
                while (it.hasNext()) {
                    BuildTriggerConfig c = it.next();
                    if (!c.onDeleted(oldName)) continue;
                    changed = true;
                    if (c.getProjects().length() != 0) continue;
                    it.remove();
                }
                if (!changed) continue;
                try {
                    if (t.getConfigs().size() == 0) {
                        p.getPublishersList().remove((Object)t);
                    }
                    p.save();
                }
                catch (IOException e) {
                    Logger.getLogger(RenameListener.class.getName()).log(Level.WARNING, "Failed to persist project setting during remove of " + oldName, e);
                }
            }
        }
    }
}

