/*
 *	P4Java - java integration with Perforce SCM
 *	Copyright (C) 2007-,  Mike Wille, Tek42
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *	You can contact the author at:
 *
 *	Web:	http://tek42.com
 *	Email:	mike@tek42.com
 *	Mail:	755 W Big Beaver Road
 *			Suite 1110
 *			Troy, MI 48084
 */

package com.tek42.perforce.process;

import java.util.Map;

import java.util.HashMap;

/**
 * Default @{link ExecutorFactory} that handles creating new {@link CmdLineExecutor}s
 * 
 * @author Mike Wille
 */
public class DefaultExecutorFactory implements ExecutorFactory {
	private Map<String, String> env;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.tek42.perforce.process.ExecutorFactory#newExecutor()
	 */
	public Executor newExecutor() {
		return new CmdLineExecutor(env);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.tek42.perforce.process.ExecutorFactory#setEnv(java.util.Map)
	 */
	public void setEnv(Map<String, String> env) {
		this.env = new HashMap<String, String>(env);
		return;
	}
}
