/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.P4Process;
import com.perforce.api.PerforceException;
import com.perforce.api.Utils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * Exception performing whole class analysis ignored.
 */
public final class JobField {
    private int code = 0;
    private String name = "";
    private int data_type = 0;
    private int len = 0;
    private int field_type = 0;
    private Vector values;
    private String preset;
    private static Hashtable fields;
    private JobField[] fieldarray;
    private static final int BASECODE = 101;
    private static final int MAXCODE = 199;
    public static final int WORD = 1;
    public static final int DATE = 2;
    public static final int SELECT = 3;
    public static final int LINE = 4;
    public static final int TEXT = 5;
    public static final int OPTIONAL = 6;
    public static final int DEFAULT = 7;
    public static final int REQUIRED = 8;
    public static final int ONCE = 9;
    public static final int ALWAYS = 10;

    public JobField() {
        if (null == fields) {
            fields = new Hashtable();
        }
        if (null == this.fieldarray) {
            this.fieldarray = new JobField[99];
        }
        this.values = new Vector();
    }

    public JobField(int code, String name, int dtype, int len, int ftype) {
        this();
        this.setDataType(dtype);
        this.setLength(len);
        this.setFieldType(ftype);
        this.setName(name);
        this.setCode(code);
    }

    public JobField(int code, String name, String dtype, int len, String ftype) {
        this();
        this.setDataType(dtype);
        this.setLength(len);
        this.setFieldType(ftype);
        this.setName(name);
        this.setCode(code);
    }

    private static JobField parseField(String def) {
        JobField jf;
        StringTokenizer st = new StringTokenizer(def);
        try {
            st.nextToken();
            int code = Integer.valueOf(st.nextToken());
            String name = st.nextToken();
            String dtype = st.nextToken();
            int len = Integer.valueOf(st.nextToken());
            String ftype = st.nextToken();
            jf = new JobField(code, name, dtype, len, ftype);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            return null;
        }
        return jf;
    }

    public static void loadFields(Env env, boolean redo) {
        if (!redo && null != fields) {
            return;
        }
        fields = new Hashtable();
        String[] cmd = new String[]{"p4", "jobspec", "-o"};
        JobField jf = null;
        try {
            String l;
            P4Process p = new P4Process(env);
            p.setRawMode(true);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (l.startsWith("#")) continue;
                if (l.startsWith("info: Fields:")) {
                    while (null != (l = p.readLine()) && l.startsWith("info: \t")) {
                        jf = JobField.parseField((String)l);
                    }
                }
                if (l.startsWith("Preset:")) {
                    // empty if block
                }
                if (!l.startsWith("Values:")) continue;
            }
            p.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public static JobField getField(String name) {
        if (null == fields) {
            fields = new Hashtable();
        }
        return (JobField)fields.get(name);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name.trim().equals("")) {
            return;
        }
        if (!this.name.trim().equals("")) {
            fields.remove(this.name);
        }
        this.name = name;
        fields.put(this.name, this);
    }

    public int getDataType() {
        return this.data_type;
    }

    public void setDataType(int dtype) {
        this.data_type = dtype;
    }

    public void setDataType(String dtype) {
        this.data_type = dtype.equals("word") ? 1 : (dtype.equals("date") ? 2 : (dtype.equals("select") ? 3 : (dtype.equals("line") ? 4 : 5)));
    }

    public int getLength() {
        return this.len;
    }

    public void setLength(int len) {
        this.len = len;
    }

    public int getFieldType() {
        return this.field_type;
    }

    public void setFieldType(int ftype) {
        this.field_type = ftype;
    }

    public void setFieldType(String ftype) {
        this.field_type = ftype.equals("optional") ? 6 : (ftype.equals("always") ? 10 : (ftype.equals("required") ? 8 : (ftype.equals("once") ? 9 : 7)));
    }

    public void setPreset(String value) {
        this.preset = value;
    }

    public String getPreset() {
        return this.preset;
    }

    public void addValue(String value) {
        this.values.addElement(value);
    }

    public Enumeration getValues() {
        return this.values.elements();
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer("<field>");
        sb.append("</field>");
        return sb.toString();
    }

    public static void main(String[] args) {
        String propfile = "/etc/p4.conf";
        Env environ = null;
        Debug.setDebugLevel((int)99);
        if (0 < args.length) {
            propfile = args[0];
        }
        try {
            environ = new Env(propfile);
        }
        catch (PerforceException ex) {
            System.out.println("Could not load properties from " + propfile + ": " + (Object)((Object)ex));
            System.exit(-1);
        }
        System.out.println(environ);
        JobField.loadFields((Env)environ, (boolean)true);
        Enumeration en = fields.keys();
        while (en.hasMoreElements()) {
            JobField jf = (JobField)fields.get(en.nextElement());
            System.out.println(jf.getName() + " [" + jf.getCode() + "]: " + jf.getDataType());
        }
        Utils.cleanUp();
    }
}

