/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Cacheable;
import com.perforce.api.CommitException;
import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.HashDecay;
import com.perforce.api.Mapping;
import com.perforce.api.P4Process;
import com.perforce.api.Utils;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Client
extends Mapping {
    private String root = "";
    private String options = "";
    private static final int DECAY_TIMEOUT = 86400000;
    private static HashDecay clients = null;
    private static long load_time = 0L;

    public Client() {
        this.getCache();
    }

    public Client(String name) {
        this((Env)null, name);
    }

    public Client(Env env, String name) {
        this();
        this.setEnv(env);
        this.setName(name);
    }

    private static synchronized HashDecay setCache() {
        if (null == clients) {
            clients = new HashDecay(86400000L);
            clients.start();
        }
        if (clients.isEmpty()) {
            load_time = 0L;
        }
        return clients;
    }

    public HashDecay getCache() {
        return Client.setCache();
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getOptions() {
        return this.options;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Client getClient(Env env, String name) {
        if (null == name || name.trim().equals("")) {
            return null;
        }
        Client c = (Client)Client.setCache().get((Object)name);
        if (null == c) {
            c = new Client(name);
        }
        if (null != env) {
            c.setEnv(env);
        }
        c.sync();
        HashDecay hashDecay = clients;
        synchronized (hashDecay) {
            clients.put((Object)name, (Cacheable)c);
        }
        return c;
    }

    public static synchronized Client getClient(String name) {
        return Client.getClient(null, (String)name);
    }

    public static Enumeration lookupClient(Env env, String prefix) {
        Client.loadClients((Env)env);
        return Client.lookupMappings((HashDecay)clients, (String)prefix);
    }

    public static Enumeration lookupClient(String prefix) {
        Client.loadClients(null);
        return Client.lookupMappings((HashDecay)clients, (String)prefix);
    }

    public static Enumeration getClients() {
        Client.loadClients(null);
        return clients.keys();
    }

    public static Enumeration getClients(Env env) {
        return Utils.getEnumeration((Iterator)Client.getClientIterator((Env)env));
    }

    public static Iterator getClientIterator(Env env) {
        Client.loadClients((Env)env);
        Enumeration en = clients.elements();
        TreeSet ts = new TreeSet();
        while (en.hasMoreElements()) {
            ts.add(en.nextElement());
        }
        return ts.iterator();
    }

    public static void loadClients() {
        Client.loadClients(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadClients(Env env) {
        String[] cmd = new String[]{"p4", "clients"};
        Client.setCache();
        HashDecay hashDecay = clients;
        synchronized (hashDecay) {
            Date date = new Date();
            if ((double)clients.getDelay() * 0.5 > (double)(date.getTime() - load_time)) {
                return;
            }
            try {
                String l;
                P4Process p = new P4Process(env);
                p.exec(cmd);
                while (null != (l = p.readLine())) {
                    if (!l.startsWith("Client")) continue;
                    try {
                        StringTokenizer st = new StringTokenizer(l.trim());
                        if (6 > st.countTokens()) continue;
                        st.nextToken();
                        String name = st.nextToken();
                        Client c = (Client)clients.get((Object)name);
                        if (null != c) {
                            c.refreshUpdateTime();
                            continue;
                        }
                        c = new Client(name);
                        c.setEnv(env);
                        st.nextToken();
                        st.nextToken();
                        c.setRoot(st.nextToken());
                        if (null != st.nextToken("'")) {
                            c.setDescription(st.nextToken());
                        } else {
                            c.setDescription("");
                        }
                        clients.put((Object)c.getName(), (Cacheable)c);
                    }
                    catch (NoSuchElementException ex) {}
                }
                load_time = new Date().getTime();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                System.out.flush();
            }
        }
    }

    public void store() throws CommitException {
        this.commit();
    }

    public void commit() throws CommitException {
        String[] cmd = new String[]{"p4", "client", "-i"};
        int cnt = 0;
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            p.println("Client: " + this.getName());
            p.println("Owner: " + this.getOwner());
            p.println("Root: " + this.getRoot());
            p.println("Description: " + this.getDescription());
            p.println("View:");
            p.println(this.getView());
            p.flush();
            p.outClose();
            while (null != (l = p.readLine())) {
                if (0 != cnt++) continue;
            }
            p.close();
        }
        catch (Exception ex) {
            throw new CommitException(ex.getMessage());
        }
    }

    public void sync() {
        this.sync(this.getName());
    }

    public void sync(String name) {
        if (!this.outOfSync(60000L)) {
            return;
        }
        String description = "";
        String[] cmd = new String[]{"p4", "client", "-o", "name"};
        cmd[3] = name;
        this.setName(name);
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (l.startsWith("#")) continue;
                if (l.startsWith("Client:")) {
                    this.setName(l.substring(8).trim());
                    continue;
                }
                if (l.startsWith("Owner:")) {
                    this.setOwner(l.substring(7).trim());
                    continue;
                }
                if (l.startsWith("Root:")) {
                    this.setRoot(l.substring(6).trim());
                    continue;
                }
                if (l.startsWith("Options:")) {
                    this.setOptions(l.substring(9).trim());
                    continue;
                }
                if (l.startsWith("Description:")) {
                    while (null != (l = p.readLine()) && l.startsWith("\t")) {
                        description = description + l + "\n";
                    }
                    this.setDescription(description);
                    continue;
                }
                if (!l.startsWith("View:")) continue;
                while (null != (l = p.readLine()) && (l.startsWith("\t") || l.startsWith(" ") || l.startsWith("//"))) {
                    this.addView(l);
                }
            }
            p.close();
            this.inSync();
        }
        catch (IOException ex) {
            Debug.out((int)1, (Throwable)ex);
        }
        this.refreshUpdateTime();
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer("<client name=\"");
        sb.append(this.getName());
        sb.append("\" owner=\"");
        sb.append(this.getOwner());
        sb.append("\" root=\"");
        sb.append(this.getRoot());
        sb.append("\" options=\"");
        sb.append(this.getOptions());
        sb.append("\">");
        sb.append(super.toXML());
        sb.append("</client>");
        return sb.toString();
    }

    public static void main(String[] argv) {
        if (argv.length < 2) {
            System.err.println("Usage: p4.Client <port> <user> [<password>]");
            System.exit(-1);
        }
        System.out.println("Clients on " + argv[0] + ":");
        Env environ = new Env();
        environ.setPort(argv[0]);
        environ.setUser(argv[1]);
        if (3 == argv.length) {
            environ.setPassword(argv[2]);
        }
        Enumeration en = Client.getClients((Env)environ);
        while (en.hasMoreElements()) {
            Client c = (Client)en.nextElement();
            System.out.println(c);
        }
        System.exit(0);
    }
}

