/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Changelist;
import com.tek42.perforce.model.Counter;
import com.tek42.perforce.model.Workspace;
import com.tek42.perforce.parse.Workspaces;
import com.tek42.perforce.process.ExecutorFactory;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.perforce.HudsonP4ExecutorFactory;
import hudson.plugins.perforce.PerforceChangeLogParser;
import hudson.plugins.perforce.PerforceChangeLogSet;
import hudson.plugins.perforce.PerforcePasswordEncryptor;
import hudson.plugins.perforce.PerforceRepositoryBrowser;
import hudson.plugins.perforce.PerforceSCM;
import hudson.plugins.perforce.PerforceSCMHelper;
import hudson.plugins.perforce.PerforceTagAction;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceSCM
extends SCM {
    String p4User;
    String p4Passwd;
    String p4Port;
    String p4Client;
    String projectPath;
    String p4Label;
    String p4Exe = "C:\\Program Files\\Perforce\\p4.exe";
    String p4SysDrive = "C:";
    String p4SysRoot = "C:\\WINDOWS";
    PerforceRepositoryBrowser browser;
    transient int lastChange;
    boolean forceSync = false;
    boolean updateView = true;
    boolean dontRenameClient = true;
    int firstChange = -1;

    @DataBoundConstructor
    public PerforceSCM(String p4User, String p4Passwd, String p4Client, String p4Port, String projectPath, String p4Exe, String p4SysRoot, String p4SysDrive, String p4Label, boolean forceSync, boolean updateView, boolean dontRenameClient, int firstChange, PerforceRepositoryBrowser browser) {
        this.p4User = p4User;
        this.setP4Passwd(p4Passwd);
        this.p4Client = p4Client;
        this.p4Port = p4Port;
        Matcher m = Pattern.compile("(@\\S+)\\s*").matcher(projectPath);
        if (m.find()) {
            p4Label = m.group(1);
            projectPath = projectPath.substring(0, m.start(1)) + projectPath.substring(m.end(1));
        }
        if (this.p4Label != null && p4Label != null) {
            Logger.getLogger(PerforceSCM.class.getName()).warning("Label found in views and in label field.  Using: " + p4Label);
        }
        this.p4Label = Util.fixEmptyAndTrim((String)p4Label);
        this.projectPath = projectPath;
        if (p4Exe != null) {
            this.p4Exe = p4Exe;
        }
        if (p4SysRoot != null && p4SysRoot.length() != 0) {
            this.p4SysRoot = p4SysRoot;
        }
        if (p4SysDrive != null && p4SysDrive.length() != 0) {
            this.p4SysDrive = p4SysDrive;
        }
        this.forceSync = forceSync;
        this.browser = browser;
        this.updateView = updateView;
        this.dontRenameClient = dontRenameClient;
        this.firstChange = firstChange;
    }

    protected Depot getDepot(Launcher launcher, FilePath workspace) {
        HudsonP4ExecutorFactory p4Factory = new HudsonP4ExecutorFactory(launcher, workspace);
        Depot depot = new Depot((ExecutorFactory)p4Factory);
        depot.setUser(this.p4User);
        PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
        depot.setPassword(encryptor.decryptString(this.p4Passwd));
        depot.setPort(this.p4Port);
        depot.setClient(this.p4Client);
        depot.setExecutable(this.p4Exe);
        depot.setSystemDrive(this.p4SysDrive);
        depot.setSystemRoot(this.p4SysRoot);
        return depot;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        PerforceTagAction pta = this.getMostRecentTagAction((Run)build);
        if (pta != null) {
            if (pta.getChangeNumber() > 0) {
                int lastChange = pta.getChangeNumber();
                env.put("P4_CHANGELIST", Integer.toString(lastChange));
            } else if (pta.getTag() != null) {
                String label = pta.getTag();
                env.put("P4_LABEL", label);
            }
        }
    }

    private String getLocalPathName(FilePath path, boolean isUnix) throws IOException, InterruptedException {
        String uriString = path.toURI().toString();
        uriString = uriString.replaceAll("file:/", "");
        uriString = uriString.replaceAll("/./", "/");
        uriString = URLDecoder.decode(uriString, "UTF-8");
        uriString = isUnix ? "/" + uriString : uriString.replaceAll("/", "\\\\");
        return uriString;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        String projectPath = this.projectPath;
        Depot depot = this.getDepot(launcher, workspace);
        boolean dontChangeRoot = build instanceof MatrixBuild;
        int RETRY_COUNT = 6;
        int WAIT_PERIOD = 10000;
        for (int retryAttempt = 0; retryAttempt < RETRY_COUNT; ++retryAttempt) {
            try {
                Workspace p4workspace = this.getPerforceWorkspace(depot, build.getBuiltOn(), launcher, workspace, (TaskListener)listener, dontChangeRoot);
                if (p4workspace.isNew()) {
                    log.println("Saving new client " + p4workspace.getName());
                    depot.getWorkspaces().saveWorkspace(p4workspace);
                } else if (p4workspace.isDirty()) {
                    log.println("Saving modified client " + p4workspace.getName());
                    depot.getWorkspaces().saveWorkspace(p4workspace);
                }
                String p4WorkspacePath = "//" + p4workspace.getName() + "/...";
                int lastChange = this.getLastChange(build.getPreviousBuild());
                log.println("Last sync'd change: " + lastChange);
                List changes = null;
                int newestChange = lastChange;
                if (this.p4Label != null) {
                    changes = new ArrayList(0);
                } else {
                    Counter counter = depot.getCounters().getCounter("change");
                    newestChange = counter.getValue();
                    if (lastChange <= 0 || lastChange >= newestChange) {
                        changes = new ArrayList(0);
                    } else {
                        List changeNumbersTo = depot.getChanges().getChangeNumbersInRange(p4workspace, lastChange + 1, newestChange);
                        changes = depot.getChanges().getChangelistsFromNumbers(changeNumbersTo);
                    }
                }
                if (changes.size() > 0) {
                    PerforceChangeLogSet.saveToChangeLog((OutputStream)new FileOutputStream(changelogFile), changes);
                    newestChange = ((Changelist)changes.get(0)).getChangeNumber();
                } else {
                    this.createEmptyChangeLog(changelogFile, listener, "changelog");
                }
                StringBuilder sbMessage = new StringBuilder("Sync'ing workspace to ");
                StringBuilder sbSyncPath = new StringBuilder(p4WorkspacePath);
                sbSyncPath.append("@");
                if (this.p4Label != null) {
                    sbMessage.append("label ");
                    sbMessage.append(this.p4Label);
                    sbSyncPath.append(this.p4Label);
                } else {
                    sbMessage.append("changelist ");
                    sbMessage.append(newestChange);
                    sbSyncPath.append(newestChange);
                }
                if (this.forceSync) {
                    sbMessage.append(" (forcing sync of unchanged files).");
                } else {
                    sbMessage.append(".");
                }
                log.println(sbMessage.toString());
                String syncPath = sbSyncPath.toString();
                long startTime = System.currentTimeMillis();
                depot.getWorkspaces().syncTo(syncPath, this.forceSync);
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                listener.getLogger().println("Sync complete, took " + duration + " ms");
                this.forceSync = false;
                this.firstChange = -1;
                if (this.p4Label != null) {
                    build.addAction((Action)new PerforceTagAction(build, depot, this.p4Label, projectPath));
                } else {
                    build.addAction((Action)new PerforceTagAction(build, depot, newestChange, projectPath));
                }
                build.getParent().save();
                return true;
            }
            catch (PerforceException e) {
                log.print("Caught Exception communicating with perforce. " + e.getMessage());
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                e.printStackTrace(pw);
                pw.flush();
                sw.flush();
                log.print(sw.toString());
                if (retryAttempt < RETRY_COUNT) {
                    try {
                        Thread.sleep(WAIT_PERIOD);
                    }
                    catch (InterruptedException exception) {}
                    continue;
                }
                throw new IOException("Unable to communicate with perforce. " + e.getMessage());
            }
            catch (InterruptedException e) {
                retryAttempt = RETRY_COUNT;
                throw new IOException("Unable to get hostname from slave. " + e.getMessage());
            }
        }
        return false;
    }

    private String getChangesPaths(Workspace p4workspace) {
        return PerforceSCMHelper.computePathFromViews((Collection)p4workspace.getViews());
    }

    public PerforceRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public ChangeLogParser createChangeLogParser() {
        return new PerforceChangeLogParser();
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        logger.println("Looking for changes...");
        Depot depot = this.getDepot(launcher, workspace);
        try {
            Workspace p4workspace = this.getPerforceWorkspace(depot, project.getLastBuiltOn(), launcher, workspace, listener, false);
            if (p4workspace.isNew()) {
                return true;
            }
            Boolean needToBuild = this.needToBuild(p4workspace, project, depot, logger);
            if (needToBuild == null) {
                needToBuild = this.wouldSyncChangeWorkspace(project, depot, logger);
            }
            if (needToBuild == Boolean.FALSE) {
                return false;
            }
            logger.println("Triggering a build.");
            return true;
        }
        catch (PerforceException e) {
            System.out.println("Problem: " + e.getMessage());
            logger.println("Caught Exception communicating with perforce." + e.getMessage());
            e.printStackTrace();
            throw new IOException("Unable to communicate with perforce.  Check log file for: " + e.getMessage());
        }
    }

    private Boolean needToBuild(Workspace p4workspace, AbstractProject project, Depot depot, PrintStream logger) throws IOException, InterruptedException, PerforceException {
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            logger.println("No previous build exists.");
            return null;
        }
        PerforceTagAction action = (PerforceTagAction)lastBuild.getAction(PerforceTagAction.class);
        if (action == null) {
            logger.println("Previous build doesn't have Perforce info.");
            return null;
        }
        int lastChangeNumber = action.getChangeNumber();
        String lastLabelName = action.getTag();
        if (lastChangeNumber <= 0 && lastLabelName != null) {
            logger.println("Previous build was based on label " + lastLabelName);
            if (this.p4Label == null) {
                logger.println("Job configuration changed to build from head, not a label.");
                return Boolean.TRUE;
            }
            if (!lastLabelName.equals(this.p4Label)) {
                logger.println("Job configuration changed to build from label " + this.p4Label + ", not from head");
                return Boolean.TRUE;
            }
            logger.println("Assuming that the workspace and label definitions have not changed.");
            return Boolean.FALSE;
        }
        if (lastChangeNumber > 0) {
            logger.println("Last sync'd change was " + lastChangeNumber);
            if (this.p4Label != null) {
                logger.println("Job configuration changed to build from label " + this.p4Label + ", not from head.");
                return Boolean.TRUE;
            }
            String root = "//" + p4workspace.getName() + "/...";
            List changeNumbers = depot.getChanges().getChangeNumbers(root, -1, 1);
            if (changeNumbers.isEmpty()) {
                return Boolean.TRUE;
            }
            int highestSelectedChangeNumber = (Integer)changeNumbers.get(0);
            logger.println("Latest submitted change selected by workspace is " + highestSelectedChangeNumber);
            if (lastChangeNumber >= highestSelectedChangeNumber) {
                logger.println("Assuming that the workspace definition has not changed.");
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return null;
    }

    private boolean wouldSyncChangeWorkspace(AbstractProject project, Depot depot, PrintStream logger) throws IOException, InterruptedException, PerforceException {
        Workspaces workspaces = depot.getWorkspaces();
        String result = workspaces.syncDryRun().toString();
        if (result.startsWith("File(s) up-to-date.")) {
            logger.println("Workspace up-to-date.");
            return false;
        }
        logger.println("Workspace not up-to-date.");
        return true;
    }

    public int getLastChange(Run build) {
        if (this.firstChange > 0) {
            return this.firstChange;
        }
        PerforceTagAction action = this.getMostRecentTagAction(build);
        if (action == null) {
            return 0;
        }
        return action.getChangeNumber();
    }

    private PerforceTagAction getMostRecentTagAction(Run build) {
        if (build == null) {
            return null;
        }
        PerforceTagAction action = (PerforceTagAction)build.getAction(PerforceTagAction.class);
        if (action != null) {
            return action;
        }
        return this.getMostRecentTagAction(build.getPreviousBuild());
    }

    private Workspace getPerforceWorkspace(Depot depot, Node buildNode, Launcher launcher, FilePath workspace, TaskListener listener, boolean dontChangeRoot) throws IOException, InterruptedException, PerforceException {
        PrintStream log = listener.getLogger();
        String nodeSuffix = "";
        String p4Client = this.p4Client;
        if (!this.nodeIsRemote(buildNode)) {
            log.print("Using master perforce client: ");
            log.println(p4Client);
        } else if (this.dontRenameClient) {
            log.print("Using shared perforce client: ");
            log.println(p4Client);
        } else {
            String host = (String)workspace.act((FilePath.FileCallable)new GetHostname(null));
            nodeSuffix = host.contains(".") ? "-" + host.subSequence(0, host.indexOf(46)) : "-" + host;
            p4Client = p4Client + nodeSuffix;
            log.println("Using remote perforce client: " + p4Client);
            depot.setClient(p4Client);
        }
        Workspace p4workspace = depot.getWorkspaces().getWorkspace(p4Client);
        assert (p4workspace != null);
        boolean creatingNewWorkspace = p4workspace.isNew();
        p4workspace.setName(p4Client);
        String localPath = this.getLocalPathName(workspace, launcher.isUnix());
        if (!localPath.equals(p4workspace.getRoot()) && !dontChangeRoot) {
            log.println("Changing P4 Client Root to: " + localPath);
            p4workspace.setRoot(localPath);
        }
        if (this.updateView || creatingNewWorkspace) {
            this.projectPath = this.fixProjectPath(this.projectPath, nodeSuffix);
            List<String> views = Arrays.asList(this.projectPath.split("\n"));
            if (!((Object)views).equals(p4workspace.getViews())) {
                log.println("Changing P4 Client View to: " + this.projectPath);
                p4workspace.clearViews();
                for (String view : views) {
                    p4workspace.addView(" " + view);
                }
            }
        }
        if (this.dontRenameClient) {
            p4workspace.setHost("");
        }
        return p4workspace;
    }

    private boolean nodeIsRemote(Node buildNode) {
        if (buildNode == null) {
            return false;
        }
        return buildNode.getNodeName().length() != 0;
    }

    private String fixProjectPath(String projectPath, String nodeSuffix) {
        String newPath = "";
        for (String line : projectPath.split("\n")) {
            Matcher depotOnly = Pattern.compile("^\\s*\\/\\/\\S+(\\/\\S+)\\s*$").matcher(line);
            Matcher depotAndWorkspace = Pattern.compile("\\s*(\\/\\/\\S+?\\/\\S+)\\s*\\/\\/\\S+?(\\/\\S+)").matcher(line);
            if (depotOnly.find()) {
                line = line + " //" + this.p4Client + nodeSuffix + "/...\n";
            } else if (depotAndWorkspace.find()) {
                line = depotAndWorkspace.group(1) + " //" + this.p4Client + nodeSuffix + depotAndWorkspace.group(2);
            }
            newPath = newPath + line + "\n";
        }
        return newPath;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public String getP4User() {
        return this.p4User;
    }

    public void setP4User(String user) {
        this.p4User = user;
    }

    public String getP4Passwd() {
        return this.p4Passwd;
    }

    public void setP4Passwd(String passwd) {
        PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
        this.p4Passwd = encryptor.appearsToBeAnEncryptedPassword(passwd) ? passwd : encryptor.encryptString(passwd);
    }

    public String getP4Port() {
        return this.p4Port;
    }

    public void setP4Port(String port) {
        this.p4Port = port;
    }

    public String getP4Client() {
        return this.p4Client;
    }

    public void setP4Client(String client) {
        this.p4Client = client;
    }

    public String getP4SysDrive() {
        return this.p4SysDrive;
    }

    public void setP4SysDrive(String sysDrive) {
        this.p4SysDrive = sysDrive;
    }

    public String getP4SysRoot() {
        return this.p4SysRoot;
    }

    public void setP4SysRoot(String sysRoot) {
        this.p4SysRoot = sysRoot;
    }

    public String getP4Exe() {
        return this.p4Exe;
    }

    public void setP4Exe(String exe) {
        this.p4Exe = exe;
    }

    public String getP4Label() {
        return this.p4Label;
    }

    public void setP4Label(String label) {
        this.p4Label = label;
    }

    public void setUpdateView(boolean update) {
        this.updateView = update;
    }

    public boolean isUpdateView() {
        return this.updateView;
    }

    public boolean isForceSync() {
        return this.forceSync;
    }

    public void setForceSync(boolean force) {
        this.forceSync = force;
    }

    public boolean isUseLabel() {
        return this.p4Label != null;
    }

    public void setDontRenameClient(boolean dontRenameClient) {
        this.dontRenameClient = dontRenameClient;
    }

    public boolean isDontRenameClient() {
        return this.dontRenameClient;
    }

    public String getFirstChange() {
        if (this.firstChange <= 0) {
            return "";
        }
        return Integer.valueOf(this.firstChange).toString();
    }

    public boolean processWorkspaceBeforeDeletion(AbstractProject<?, ?> project, FilePath workspace, Node node) {
        Logger.getLogger(PerforceSCM.class.getName()).info("Veto workspace cleanup");
        return false;
    }
}

